#ifndef USE_CAN_F303K8
#define USE_CAN_F303K8

#include "mbed.h"
#include "stm32f3xx_hal_can.h"
#include "stm32f3xx_hal.h"
#include "core_cm4.h"

namespace CAN_STATE{
    const int RESET             = 0x00U;  /*!< CAN not yet initialized or disabled */
    const int READY             = 0x01U;  /*!< CAN initialized and ready for use   */
    const int BUSY              = 0x02U; /*!< CAN process is ongoing              */
    const int BUSY_TX           = 0x12U;  /*!< CAN process is ongoing              */
    const int BUSY_RX0          = 0x22U;  /*!< CAN process is ongoing              */
    const int BUSY_RX1          = 0x32U;  /*!< CAN process is ongoing              */
    const int BUSY_TX_RX0       = 0x42U;  /*!< CAN process is ongoing              */
    const int BUSY_TX_RX1       = 0x52U;  /*!< CAN process is ongoing              */
    const int BUSY_RX0_RX1      = 0x62U;  /*!< CAN process is ongoing              */
    const int BUSY_TX_RX0_RX1   = 0x72U;  /*!< CAN process is ongoing              */
    const int TIMEOUT           = 0x03U;  /*!< CAN in Timeout state                */
    const int ERROR             = 0x04U;   /*!< CAN error state                     */
};

enum FIFO{
    FIFO_0,
    FIFO_1,
};

enum IRQ_MODE{
    RX_FIFO0,
    RX_FIFO1,
    TX_READY,
};

enum PROCESS_RESULT{
    //ERROR = 0,
    //SUCCESS = 1,
    BUSY = 2,
    TIMEOUT = 3,
};

enum BAUDRATE{
    CAN_125KHZ,
    CAN_250KHZ,
    CAN_500KHZ,
    CAN_1MHZ,
};

enum DATA_CATEGORY{
    STANDARD_ID,
    EXTENDED_ID,
    IDE,
    RTR,
    DLC,
    FMI,
    FIFO_NUMBER,
    RX_DATA_0,
    RX_DATA_1,
    RX_DATA_2,
    RX_DATA_3,
    RX_DATA_4,
    RX_DATA_5,
    RX_DATA_6,
    RX_DATA_7,
};

class CanStm{
    
    public:
        int init(int baudrate);
        int transmit(uint32_t id, int format, uint8_t* tx_array);
        int receive();
        int getData(int category_data);
        int attach(uint32_t id,void func(),int irq_mode);
        void exitIrqHandler(void);
        CanRxMsgTypeDef rx_data[2];
        CAN_HandleTypeDef canHandler;
    private:
        HAL_StatusTypeDef hal_can_init(CAN_HandleTypeDef* hcan);
        HAL_StatusTypeDef hal_can_transmit(CAN_HandleTypeDef* hcan, uint32_t Timeout);
        HAL_StatusTypeDef hal_can_configfilter(CAN_HandleTypeDef* hcan,CAN_FilterConfTypeDef* sFilterConfig);
        void hal_can_mspinit(CAN_HandleTypeDef* hcan);
        void setPriority(IRQn_Type IRQn);
        void ConvertMessage(CAN_HandleTypeDef* hcan,CanRxMsgTypeDef* rx_message,uint32_t FIFONumber);

        uint32_t use_fifo;
        uint32_t function;
        uint16_t can_rx_data[9];
        float CAN_TIMEOUT_VALUE;
        Timer timer;
};
#endif
