#ifndef ENCODER_H
#define ENCODER_H

#include "mbed.h"
#include "arm_math.h"

enum CH{
	DISTANCE,
	RPM,
	VELOCITY,
	ACCELERATION,
	OMEGA,
	
	DELTA_DISTANCE,
};

enum ENCODER_MODE{
	X1_ENCODE,
	X2_ENCODE,
	X4_ENCODE,
	
};

enum TYPE_NUMBER{
	NORMAL,
	DELTA,
	TYPE_NUMBER,
};

enum BEFORE_NUMBER{
	CURRENT,
	ONE_BEFORE,
	TWO_BEFORE,
	BEFORE_NUMBER,
};

class Encoder
{
    public:
        Encoder(PinName a_phase , PinName b_phase );
        void calState();
		
		float getState(int ch);
		
		void reset();
		
        void init(float _ppr, float _radius,float _dt,int mode);
    private:
  		void readAphaseRise();
		void readAphaseFall();
  		void readBphaseRise();
		void readBphaseFall();
		float rpm, distance, omega, velocity, radius, delta_distance,
        	  ppr, dt, dt_square, circle, acceleration;
	  	float ppr_rev, dt_rev;
		float count[TYPE_NUMBER][BEFORE_NUMBER];/* = {
			{[NORMAL][NOW], [NORMAL][ONE_BEFORE], [NORMAL][TWO_BEFORE]},
			{[DELTA][NOW], [DELTA][ONE_BEFORE], [DELTA][TWO_BEFORE]}
		}
		*/
        InterruptIn aPhase;
        InterruptIn bPhase;
};

#endif

