/* Sample program
 * Hybrid image
 * AS-289R2 Thermal Printer Shield
 * NADA ELECTRONICS, LTD.
 * Copyright (c) 2017 Takehiro Yamaguchi, MIT License
 */

#include "mbed.h"
#include "AS289R2.h"
#include "image.h"  // MonochromeBitmap to cpp : http://www.nada.co.jp/as289r2/en/ex_bitmap.html

/* NUCLEO-F746ZG */
AS289R2 tp(D1);

DigitalOut myled(LED1);

int main()
{
    /* initialize */
    tp.initialize();
    tp.putLineFeed(2);

    /* Hybrid image */
    int lines = hybridimage_len / 48;
    tp.printBitmapImage(0x63, lines, hybridimage);
    tp.putLineFeed(6);

    while(1) {
        myled = 1; // LED is ON
        wait(0.2); // 200 ms
        myled = 0; // LED is OFF
        wait(1.0); // 1 sec
    }
}
