#include "CQueue.h"
#include "mbed.h"

CQueue::CQueue(int s){
    init(s);
}
void  CQueue::init(int s){
    lock=0;
    size=s;
    buffer=new char[size];
    clear();
}

void CQueue::clear(){
   head=tail=0;
}
int CQueue::getSize(){
   return size;
}
int CQueue::getCurrentPosition(){
   return head;
}


int CQueue::isAvailable(){
    if(head==tail){
       return 0;
    }
    return 1;
}
void CQueue::getLock(){
    if(lock==0){
       lock=1;
       return;
    }
    else{
       while(lock!=0){
          wait(0.001);
       }
       lock=1;
       return;
    }
}
void CQueue::releaseLock(){
   if(lock==0) return;
   else{
      lock=0;
   }
}
int CQueue::putc(char x){
   int rtn;
   this->getLock();
//   printf("start-putc(%d) size=%d head=%d tail=%d\n\r",x,size,head,tail);

    if(head==size){
       if(tail>0){
          head=0;
          this->buffer[head]=x;
          head++;
          rtn= 1;
       }
       else{
          rtn= 0;
       }
    }
    else
    if(head>size){
       rtn= 0;
    }
    else
    if(head==tail){
       this->buffer[head]=x;
       head++;
       rtn=1;
    }
    else
    if(head>tail){
       this->buffer[head]=x;
       head++;
       rtn= 1;
    }
    else
    if(head-1==tail){
       rtn= 0;
    }
    else{
       this->buffer[head]=x;
       head++;
       rtn= 1;
    }    
//    printf("end-putc head=%d tail=%d rtn=%d\n\r",head,tail,rtn);
    this->releaseLock();
    return rtn;
}
int CQueue::getcNW(){
    char rtn;
    this->getLock();
//    printf("start-getcNW size=%d head=%d tail=%d\n\r",size, head,tail);
    if(tail==size){
       if(head>0){
          tail=0;
          rtn=this->buffer[tail];
          tail++;
       }
       else{
          rtn= 0;
       }
    }
    else
    if(tail>size){
       rtn= 0;
    }
    else
    if(head==tail){
       rtn= 0;
    }
    else
    if(head>tail){
       rtn=this->buffer[tail];
       tail++;
    }
    else{
       rtn=this->buffer[tail];
       tail++;
    }    
//    printf("end getc-NW head=%d tail=%d rtn=%d\n\r",head,tail,rtn);
    this->releaseLock();
    return rtn; 
}

int CQueue::lookAHead1(){
  if(tail==head) return 0;
  return this->buffer[tail];
}
int CQueue::getc(){
   int rtn;
//   printf("start-getc head=%d tail=%d\n\r",head,tail);
   int c=this->lookAHead1();
   while(c==0){
     wait(0.001);
     c=this->lookAHead1();
   }
   rtn=this->getcNW();
//   printf("end-getc-head=%d tail=%d rtn=%d\n\r",head,tail,rtn);
   return rtn;
}

int CQueue::getString(char *s, int max){
   int i;
   i=0;
   while(1){
     if(i>=max) return 0;
     int c=this->lookAHead1();
     while(c==0){
       wait(0.001);
       c=this->lookAHead1();
     }
     if(c=='\r'){
        s[i]='\0';
//        printf("cr enterd, string=%s\n\r",s);
        c=this->getc();
        c=this->lookAHead1();
        if(c=='\n'){
           c=this->getc();
        }
        return 1;
     } 
     else
     if(c=='\n'){
        s[i]='\0';
        c=this->getc();
        c=this->lookAHead1();
        if(c=='\r'){
           c=this->getc();
        }
        return 1;
     }
     else
     if(c=='\0'){
        s[i]='\0';
        return 1;
     }
     else
     {
       s[i]=this->getc(); 
       i++;
     }
   }
}

int CQueue::isInChars(char c, char *b){
  while(*b!='\0'){
     if(c==*b){
        return 1;
     }
     else{
        b++;
     }
  }
  return 0;
}

int CQueue::getStringBeforeBreak(char *s, int max, char *b){
   int i;
   i=0;
   while(1){
     if(i>=max){
        return 0;
     }
     char c=this->lookAHead1();
     while(c==0){
       wait(0.001);
       c=this->lookAHead1();
     }
     if(isInChars(c,b)){
        s[i]='\0';
        return 1;
     } 
     else{
        c=this->getc();
        s[i]=c;
        i++;
     }
   }
}

