
#include "XBee.h"
#include "ResponseQueue.h"
#include <stdio.h>

    ResponseQueue::ResponseQueue(){
       init();
    }
    void ResponseQueue::init() {
         queueHead= 0;
         queueTail= 0;
         responseStoreMax=10;
         responseStorePointer=0;
         queueMax=10;
         queue= &(new  (AtCommandResponse *)[queueMax]);
         responseStore=&(new (AtCommandResponse *)[responseStoreMax]);
         for(int i=0;i<queueMax;i++){
            queue[i]=NULL;
         }
         /*
         for(int i=0;i<5;i++){
            AtCommandResponse *b= new AtCommandResponse();
            collectResponse(b);
         }
         */
    }
    
    AtCommandResponse* ResponseQueue::requestResponse(){
//       printf("... requestBuffer ...start, bufferStoreMax=%d ",bufferStoreMax);
       AtCommandResponse *b=NULL;
       if(responseStorePointer==0){
          b=new AtCommandResponse();
//          printf(" ... return n=%d\n\r",b->getNumber());
          return b;
       }
       if(responseStorePointer>0){
          responseStorePointer--;
          b=responseStore[responseStorePointer];
//          printf(" ... return n=%d\n\r",b->getNumber());
          return b;
       }
       return NULL;       
    }
    int ResponseQueue::collectResponse(AtCommandResponse *b){
//       printf("... collectBuffer, bufferStoreMax=%d n=%d\n\r",bufferStoreMax,b->getNumber());
       if(responseStorePointer<responseStoreMax){
           responseStore[responseStorePointer]=b;
           responseStorePointer++;
           return 1;
       }
       return -1;
    }
    int ResponseQueue::putResponse(AtCommandResponse *b) {
//       printf("... putBuffer %d..queueHead=%d queueTail=%d\n\r",b->getNumber(),queueHead,queueTail);
       if(queueHead>queueMax) return -1;
       if(queueTail>queueMax) return -1;
       if(queueHead<0) return -1;
       if(queueTail<0) return -1;
       if(queueHead>=queueTail){
         if(queueHead<queueMax){
            queue[queueHead]=b;
            queueHead++;
            return 1;
         }
         else
         if(queueHead==queueMax){
            if(queueTail>0){
               queue[0]=b;
               queueHead=1;
               return 1;
            }
         }
         else{
            return -1;
         }
       }
       else{
            queue[queueHead]=b;
            queueHead++;
            return 1;
       }
       return -1;
    }
    AtCommandResponse * ResponseQueue::getResponse(){
//       printf("... getBuffer..queueHead=%d queueTail=%d ",queueHead,queueTail);
       AtCommandResponse *b=NULL;
       if(queueHead>queueMax) return NULL;
       if(queueTail>queueMax) return NULL;
       if(queueHead<0) return NULL;
       if(queueTail<0) return NULL;
       if(queueHead>queueTail){
            b=queue[queueTail];
            queueTail++;
//            printf("buffer number=%d\n\r",b->getNumber());
            return b;
       }
       if(queueHead==queueTail){
            return NULL;
       }
       else{
         if(queueTail<queueMax){
            b=queue[queueTail];
            queueTail++;
//            printf("buffer number=%d\n\r",b->getNumber());
            return b;
         }
         else
         if(queueTail==queueMax){
            if(queueHead>0){
               queueTail=0;
               b=queue[queueTail];
               queueTail++;
//               printf("buffer number=%d\n\r",b->getNumber());
               return b;
             }
             else{
                return NULL;
             }
         }
         else{
             return NULL;
         }
       }
     }
     int ResponseQueue::length(){
          if(queueHead>=queueTail){
             return queueHead-queueTail;
          }
          else{
             int w=queueMax-queueTail;
             return w+queueHead;
          }
      }

