#include "mbed.h"
#include "XBee.h"

XBee xbee(p13, p14);

int main() {
    uint8_t Cmd[] = {'D', '4'};
    uint8_t Low[] = {0x05};
    uint8_t Val[] = {0x04};
    XBeeAddress64 remoteAddress(0x0013A200, 0x403A8C82);
    RemoteAtCommandRequest remoteAtRequest;

    wait(1);
    xbee.begin(115200);

    remoteAtRequest = RemoteAtCommandRequest(remoteAddress, Cmd, Low, sizeof(Low));
    remoteAtRequest.setApplyChanges(true);

    remoteAtRequest.setCommandValue(Val);
    remoteAtRequest.setCommandValueLength(sizeof(Val));
    xbee.send(remoteAtRequest);
}
