#include "AQM1602XA.h"

AQM1602XA::AQM1602XA(PinName sda, PinName scl, char slave_adr)
    : wire(sda, scl) {
    address = slave_adr;
    initialize();
}


void AQM1602XA::writeCommand(char cmd) {
    char bytes[2];
    bytes[0] = 0x00;
    bytes[1] = cmd;
    wire.write(address, bytes, 2);
    wait(0.01);
}
        
void AQM1602XA::writeData(char data) {
    char bytes[2];
    bytes[0] = 0x40;
    bytes[1] = data;
    wire.write(address, bytes, 2);
    wait(0.001);
}

void AQM1602XA::initialize() {
    char cmd[] =  {0x38, 0x39, 0x14, 0x73, 0x56, 0x6c, 0x38, 0x01, 0x0c};
    wait(0.1);
    for(int i = 0; i < 9; i++) {
        writeCommand(cmd[i]);
    }    
}

void AQM1602XA::printString(int row, char *str) {
    int len = strlen(str);
    if(len > 16)
        len = 16;
    if(row == 0) {
        writeCommand(0x80);
    }
    if(row == 1) {
        writeCommand(0x40 + 0x80);
    }
    for(int i = 0; i < len; i++) {
        writeData(*(str + i));
    }
}