#include <mbed.h>
#include "WeatherHacks.h"

#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "XMLaide.h"

#define RSS_URL      "http://weather.livedoor.com/forecast/rss/area/130010.xml"

#if 0
//Enable debug
#define DBG(x, ...) std::printf("[WeatherHacks : DBG]"x"\r\n", ##__VA_ARGS__);
#define WARN(x, ...) std::printf("[WeatherHacks : WARN]"x"\r\n", ##__VA_ARGS__);
#else
//Disable debug
#define DBG(x, ...)
#define WARN(x, ...)
#endif

#define ERR(x, ...) std::printf("[WeatherHacks : ERR]"x"\r\n", ##__VA_ARGS__);

#if 0
#define TERMINAL(x, ...) std::printf("[WeatherHacks :]"x"\r\n", ##__VA_ARGS__);
#else
#define TERMINAL(x, ...) 
#endif

extern HTTPClient httpClient;

void WH_init(void) 
{
    
}

#define LINK_SIZE 200
static void getLink(const char *buff, char *link)
{
    const char *p = buff ;
    p = XML_getTag(p, "item") ; p = XML_getTag(p, "item") ; p = XML_getTag(p, "link") ;
    p = XML_getElement(p, link, LINK_SIZE) ;
}

static const char *getTodayP(const char *p) {
    return XML_getTag(p, "table") ;
}

static const char *getTomorrowP(const char *p) {
    p    = XML_getTag(p, "table") ; p = XML_getTag(p, "table") ;
    return XML_getTag(p, "table") ;
}

#define TEMP_SIZE 5
static const char *getHiTemp(const char *p, char *hi)
{
    p = XML_getTag(p, "table") ; p = XML_getTag(p, "td") ; p = XML_getTag(p, "td") ;
    p = XML_getTag(p, "span") ;
    p = XML_getElement(p, hi, 2) ;
    return p ;
}

static const char *getLoTemp(const char *p, char *lo)
{
    p = XML_getTag(p, "tr") ; p = XML_getTag(p, "tr") ;
    p = XML_getTag(p, "td") ; p = XML_getTag(p, "td") ;
    p = XML_getTag(p, "span") ;
    p = XML_getElement(p, lo, 2) ;
    return p ;
}

static const char *getPrec(const char *p, char *prec)
{
    p = XML_getTag(p, "th") ; p = XML_getTag(p, "th") ;
    p = XML_getTag(p, "td") ;    p = XML_getTag(p, "td") ; p = XML_getTag(p, "td") ;
    p = XML_getElement(p, prec, 2) ;
    if(strcmp(prec, "0%") == 0)strcpy(prec, " 0") ;
    return p ;
}

static void getInfo(const char *buff, char *hi, char *lo, char *prec)
{
    #define JST (9*60*60)
    struct tm t;
    time_t ctTime;
    ctTime = time(NULL) + JST ;
    t  = *localtime(&ctTime);
    TERMINAL("Time: % 2d:%02d => ", t.tm_hour, t.tm_min) ;
    const char *p ;
    
    if(t.tm_hour >= 12) {
        p = getTomorrowP(buff) ;
    } else {
        p = getTodayP(buff) ;
    }
    p = getHiTemp(p, hi) ;
    p = getLoTemp(p, lo) ;
    p = getPrec(p, prec) ;
    TERMINAL("Hi=%s, Lo=%s, Prec=%s\n", hi, lo, prec) ;
}

#define FREE(p) if(p)free(p)
#define BUFF_SIZE 1024*12

void WH_getInfo(char *buff, int size, char *hiTemp, char *loTemp, char *prec)
{
    int ret ;
    char link[LINK_SIZE] ;

    ret = httpClient.get(RSS_URL, buff, size);
    if (!ret) {
        DBG("Result: %s\n", buff);
    } else {
        ERR("Error %s\n- ret = %d - HTTP return code = %d\n", RSS_URL, ret, httpClient.getHTTPResponseCode());
    }
    
    getLink(buff, link) ; DBG("link=%s\n", link) ;
    ret = httpClient.get(link, buff, size) ;
        if (!ret) {
        DBG("Result: %s\n", buff) ;
    } else {
        ERR("Error %s\n- ret = %d - HTTP return code = %d\n", link, ret, httpClient.getHTTPResponseCode());
    }
    getInfo(buff, hiTemp, loTemp, prec);

}
