/* mbed VLSI VS1053t library
 *
 * Thread based VS1053 class inherited by VS1053b
 *
 */


#include "mbed.h"
#include "rtos.h"

#include "defines.h"
#include "VS1053t.h"

VS1053t :: VS1053t(
    PinName mosi, PinName miso, PinName sck,
    PinName cs, PinName rst, PinName dreq, PinName dcs,
    char*   buffer, int  buffer_size, bool thread 
    ):
    
    VS1053( mosi, miso, sck, cs, rst, dreq, dcs,
            buffer, buffer_size)
{   }

Semaphore lock_buff(1) ;

unsigned int VS1053t::waitBuffer(unsigned int size, uint32_t time) {
    int n ;
    WaitingSize = size ;
    while ((n = VS1053t::bufferFree()) < size) {
        if(thread)
            lock_buff.wait(time) ;
        else
            wait_ms(100) ;
    }
    // if(n < size) { time out
    return(n) ;
}

unsigned char VS1053t::bufferGetByte(void) {
    unsigned char retVal = 0x00;
    if (bufferCount() > 0x00) {
        retVal = *_bufferReadPointer++;
        if (_bufferReadPointer >= _buffer + BUFFER_SIZE) {
            _bufferReadPointer = _buffer;
        }
    }
    if (thread && (VS1053t::bufferFree() >= WaitingSize))
        lock_buff.release() ;
    return retVal;
}
