#include "mbed.h"
#include <string>
#include <map>
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "XMLaide.h"
#include "matchLine.h"

#define API_URL      "http://transit.loco.yahoo.co.jp/traininfo/"

#if 0
//Enable debug
#define DBG(x, ...) std::printf("[yahooTrain : DBG]"x"\r\n", ##__VA_ARGS__);
#define WARN(x, ...) std::printf("[yahooTrain : WARN]"x"\r\n", ##__VA_ARGS__);
#else
//Disable debug
#define DBG(x, ...)
#define WARN(x, ...)
#endif

#define ERR(x, ...) std::printf("[yahooTrain : ERR]"x"\r\n", ##__VA_ARGS__);

extern HTTPClient httpClient;
extern matchLine watchList ;

bool YahooT_query(const char *query, char *recv, unsigned int size)
{
    int ret ;
#define BUFF_SIZE   256
    char queryBuff[BUFF_SIZE] ;
    sprintf(queryBuff, "%s%s", API_URL, query) ;
    printf("link=%s\n", queryBuff) ;
    memset(recv, '\0', size) ;
    ret = httpClient.get(queryBuff, recv, size);
    if (!ret) {
        //DBG("Result: %s\n", recv);
        return true ;
    } else {
        ERR("Error - %s\n ret = %d - HTTP return code = %d\n", queryBuff, ret, httpClient.getHTTPResponseCode());
        return false ;
    }
}

bool YahooT_getStat(const char *buff)
{
    const char *p = buff ;
    const char *endTd ; 
    const char *endTbl ;
    const char *next ;
    const char *span ;
#define LINE_SIZE 40
#define STAT_SIZE 40
#define DESC_SIZE 200
    char line[LINE_SIZE] ;
    char stat[STAT_SIZE] ;
    char desc[DESC_SIZE] ;
    bool delay = false ;
    
    while(1) {
        if((p = XML_getTag(p, "table")) == NULL)break ;
        endTbl = XML_getTag(p, "/table") ;
        while(next = XML_getTag(p, "td")) {
            if(next == NULL)break ;
            if(next > endTbl)break ;
            p = XML_getTag(p, "a") ;
            p = XML_getElement(p, line, LINE_SIZE) ;
            p = XML_getTag(p, "td");
            endTd = XML_getTag(p, "/td") ;
            span = XML_getTag(p, "span");
            if((span != NULL) && (span < endTd)) {
                p = XML_getTag(span, "span");
                p = XML_getElement(p, stat, STAT_SIZE) ;
            } else {
                p = XML_getElement(p, stat, STAT_SIZE) ;
            }
            p = XML_getTag(p, "td");
            p = XML_getElement(p, desc, DESC_SIZE) ;
            if(watchList.find(line) && (string)stat != "平常運転"){
                delay = true ;
                printf("Delay=>%s[%s]:%s\n", line, stat, desc) ;
            }
            DBG("%s[%s]:%s\n", line, stat, desc) ;
        }
        DBG("End of Table") ;
    }
    DBG("End of Buff") ;
    return delay ;
}


