#include <mbed.h>
#include <stdio.h>
#include <string.h>
#include <vector>

#include <SDFileSystem.h>
#include "matchLine.h"

SDFileSystem sdCard(PTE3, PTE1, PTE2, PTE4, "sd"); // SD for FRDM-K64F

#define ERR(x, ...) std::printf("[DigitalClock : ERR]"x"\r\n", ##__VA_ARGS__);

matchLine::matchLine()  {} ;
matchLine:: ~matchLine () { };

static void removeCRLF(char *str)
{
    for(int i = strlen(str)-1; i>0 ; i--) {
        if((str[strlen(str)-1] == '\n') || (str[strlen(str)-1] == '\r'))
            str[strlen(str)-1] = '\0' ;
        else break ;
    }
}

bool matchLine::getList(string filename)
{
    char line[100] ;
    FILE *fp ;
    fp = fopen(filename.c_str(), "r");
    if (fp == NULL) {
        ERR("Cannot open \"%s\"\n",filename.c_str()) ;
        return false ;
    }
    while (fgets(line, sizeof(line), fp)) {
        removeCRLF(line) ;
        list.push_back(line) ;
    }
    fclose(fp) ;
    return true ;
}

bool matchLine::find(string line)
{
    int pos ;
    string name ;
    for(int i=0; i<list.size(); i++) {
        pos = line.find(list[i]) ;
        if(pos != string::npos)return true ;
    }
    return false ;
} ;
