#include <mbed.h>
#include <string>
#include "TrainStat.h"
#include "tokyoMetro.h"
#include "yahooTrain.h"
#include "matchLine.h"

#define ERR(x, ...) std::printf("[TrainStat : ERR]"x"\r\n", ##__VA_ARGS__);

#if 0
#define TERMINAL(x, ...) std::printf("[TrainStat :]"x"\r\n", ##__VA_ARGS__);
#else 
#define TERMINAL(x, ...) 
#endif

TrainStat::TrainStat(enum infoSource s) {
        source = s ;
} ;
 
TrainStat::~TrainStat(){ } ;

void TrainStat::setBuff(char *buff, int size)
{
    recvBuff = buff ;
    recvSize = size ;
}

bool TrainStat::getStat()
{
    int ret ;
    switch(source) {
    case YAHOO_TRAIN: 
        ret = YahooT_query("area/4/", recvBuff, recvSize) ;
        if(ret)ret = YahooT_getStat(recvBuff) ;
        break ;
    case TOKYO_METRO:
        ret = TMetro_query("datapoints", "odpt:TrainInformation", recvBuff, recvSize) ;
        if(ret)ret = TMetro_getStat(recvBuff) ;
        break ;
    default:
        return false ;
    }
    TERMINAL("%s\n", ret?"Delay":"No Delay") ; 
    return ret ;
}
