#include "mbed.h"
#include <ctype.h>

#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "NTPClient.h"
#include "AlarmClock.h"
#include "TrainStat.h"
#include "WeatherInfo.h"
#include "matchLine.h"

#if 0
//Enable debug
#define DBG(x, ...) std::printf("[Main : DBG]"x"\r\n", ##__VA_ARGS__);
#define WARN(x, ...) std::printf("[Main : WARN]"x"\r\n", ##__VA_ARGS__);
#else
//Disable debug
#define DBG(x, ...)
#define WARN(x, ...)
#endif

#define ERR(x, ...) std::printf("[Main : ERR]"x"\r\n", ##__VA_ARGS__);

AlarmClock alarmclock (
    /* Segment 0 - 6, Dot */       PTB19,PTC0, D3, D1, D0, PTC1, D4, D2,
    /* Digit 1 - 4        */       D5, PTC9, PTC8, PTB18,
    /* Alarm, Hour, Min, Tone */   D13, D15, D14, PTC11
)  ;

TrainStat   trainstat(/* YAHOO_TRAIN*/ TOKYO_METRO) ;
WeatherInfo weatherinfo(WEATHER_HACKS) ;
HTTPClient httpClient;
matchLine   watchList ;

static void ntp(char *site)
{
    NTPClient ntp;

    alarmclock.setLED(33, 33) ;
    if (ntp.setTime(site) == 0) {
        alarmclock.flashLED() ;
    } else {
        alarmclock.setLED(0, 0) ;
        wait(30.0) ;
        return ;
    }
}

void clock_main(void const *av)
{

    alarmclock.start() ;
    while(1) {
        alarmclock.poll() ;
    }

}

#if defined(ANIMATION)
#define FRONT0 0x06
#define FRONT1 0x79 
#define FRONT2 0x49
#define MIDDLE 0x49
#define TAIL0  0x49

#define TAIL1  0x4f
#define TAIL2  0x30
#define ROCK   0x5c
#define BLANK  0x00

static unsigned int delayPtn[14][4] = {
    { BLANK,  BLANK, BLANK,  BLANK } ,
    { FRONT1, BLANK, BLANK, ROCK } ,
    { FRONT2, FRONT0,BLANK, ROCK } ,
    { TAIL0, FRONT1,BLANK, ROCK } ,
    { TAIL1, FRONT2, FRONT0,ROCK } ,
    { TAIL2, MIDDLE, FRONT1,ROCK } ,
    { TAIL2, MIDDLE, FRONT1,ROCK } ,
    { TAIL2, MIDDLE, FRONT1,ROCK } ,
    { TAIL2, MIDDLE, FRONT1,ROCK } ,
    { TAIL2, MIDDLE, FRONT1,ROCK } ,
    { TAIL2, MIDDLE, FRONT1,ROCK } ,
    { TAIL2, MIDDLE, FRONT1,ROCK } ,
    { TAIL2, MIDDLE, FRONT1,ROCK } ,
    { BLANK,  BLANK, BLANK,  BLANK } 
} ;

static unsigned int noDelayPtn[14][4] = {
    { BLANK,  BLANK, BLANK,  BLANK } ,
    { MIDDLE, FRONT1,BLANK,  BLANK } ,
    { TAIL0,  FRONT2,FRONT0, BLANK } ,
    { TAIL1,  MIDDLE,FRONT1, BLANK } ,
    { TAIL2,  TAIL0, FRONT2, FRONT0 } ,
    { BLANK,  TAIL1, MIDDLE, FRONT1 } ,
    { BLANK,  TAIL2, TAIL0,  FRONT2 } ,
    { BLANK,  BLANK, TAIL1,  MIDDLE  } ,
    { BLANK,  BLANK, TAIL2,  TAIL0 } ,
    { BLANK,  BLANK, BLANK,  TAIL1 } ,
    { BLANK,  BLANK, BLANK,  TAIL2 } ,
    { BLANK,  BLANK, BLANK,  BLANK } ,
    { BLANK,  BLANK, BLANK,  BLANK } ,
    { BLANK,  BLANK, BLANK,  BLANK } 
} ;
#endif

static void setLED_Tdelay(bool delay)
{
#if !defined(ANIMATION)
/* Delay/No Delay */
    const unsigned int d[4] = { 0x6e, 0x77, 0x38, 0x5e} ;
    const unsigned int n[4] = { 0x38, 0x5e, 0x5c, 0x37} ;

    int index ;

    if(delay){
         DBG("Delay\n") ;
         for(index=8*4; index<8*5; index++)
             alarmclock.setOptVal(index, d, 8) ;
    } else {
         DBG("No Delay\n") ;
         for(index=8*4; index<8*5; index++)
             alarmclock.setOptVal(index, n, 8) ;
    }
#else
    #define TRAIN_INDEX (8*4)
    for(int i=0; i<14; i++)
        alarmclock.setOptVal(i+TRAIN_INDEX, delay ? delayPtn[i] : noDelayPtn[i], 1) ;
#endif

}
 
#define DUSH  0x40
#define BLANK 0x00
static void char2LED(const char *str, unsigned int *ptn) {
    int i ;
    
    if(isdigit(str[0]) && isdigit(str[1])){
        i = atoi(str) ; 
        ptn[0] = alarmclock.getPtn(i%10) ;
        ptn[1] = alarmclock.getPtn(i/10) ;
    } else if((str[0] == ' ')&&(str[1] == '0')) {
        ptn[0] = alarmclock.getPtn(0) ;    
        ptn[1] = BLANK ;   
    } else {
        ptn[0] = DUSH ;
        ptn[1] = DUSH ;
    }
}

static unsigned int precPtn[8][2] = {
    { 0x20, 0x00 } ,    { 0x30, 0x20 } ,    { 0x12, 0x30 } ,    { 0x06, 0x12 } ,
    { 0x24, 0x06 } ,    { 0x30, 0x24 } ,    { 0x10, 0x30 } ,    { 0x00, 0x10 } 

} ;

#define PREC(j, led0, led1) { led0 = precPtn[j][0]; led1 = precPtn[j][1]; }
 
static void setLED_WInfo(const char *hi, const char *lo, const char *prec)
{
    unsigned int hi_ptn[4] ;
    unsigned int lo_ptn[4] ; 
    unsigned int prec_ptn[4] ;
    int index ;

    DBG("hi=%s, lo=%s, prec=%s\n", hi, lo, prec) ;

    char2LED(hi, hi_ptn) ;
    hi_ptn[2] = 0x10 ;
    hi_ptn[3] = 0x76 ; 
    for(index=0; index<8; index++)
        alarmclock.setOptVal(index, hi_ptn, 8) ;
      
    char2LED(lo, lo_ptn) ;
    lo_ptn[2] = 0x5c ;
    lo_ptn[3] = 0x38 ; 
    for( ; index<16; index++)
    alarmclock.setOptVal(index, lo_ptn, 8) ;

    #define PREC_INDEX (8*2)
    for(int i=0; i<16; i++) {
        char2LED(prec, prec_ptn) ;
        PREC(i%8, prec_ptn[3], prec_ptn[2]) ;
        alarmclock.setOptVal(i+PREC_INDEX, prec_ptn, 1) ;
    }
}

#define BUFF_SIZE 1024*64
static char recvBuff[BUFF_SIZE] ;
void net_main(void const *av)
{
    int count = 0 ;
#define TEMP_SIZE 5
    char hiTemp[TEMP_SIZE], loTemp[TEMP_SIZE], prec[TEMP_SIZE] ;

    watchList.getList("/sd/watchingLines.txt") ;
    trainstat.setBuff(recvBuff, BUFF_SIZE) ;
    weatherinfo.setBuff(recvBuff, BUFF_SIZE) ;

    while(1) {
        if(count%60 ==0){
            int stat = trainstat.getStat() ;
            setLED_Tdelay(stat) ;
            if(stat)alarmclock.alarmAhead(1*60*60) ;
            else    alarmclock.alarmAhead(0) ;
            
        }
        if(count%60 ==0) {
            DBG("weatherinfo.getInfo") ;
            weatherinfo.getInfo(hiTemp, loTemp, prec) ;
            setLED_WInfo(hiTemp, loTemp, prec) ;
        }
        if(count%60*60*24)
                ntp("ntp.jst.mfeed.ad.jp") ;
        count++ ;
        wait(1.0) ;
    }
}
 
int main()
{

    int ret ;
    EthernetInterface eth ;
#define RESTART_TIMES 3

    alarmclock.setLED(11, 11) ;
    ret = eth.init();
    alarmclock.setLED(22, 22) ;
    while(1) {
        ret = eth.connect();
        if(ret == 0)break ;
        Thread::wait(10);
    }
    ntp("ntp.jst.mfeed.ad.jp") ;

#define NET_STACK   24000
    Thread t_clock(clock_main, NULL, osPriorityHigh);
    Thread t_net  (net_main,   NULL, osPriorityNormal, NET_STACK  );

    while(1)Thread::wait(1000);
}
