#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

#define SERVER_URL "https://192.168.10.15/index.html"

EthernetInterface eth;
HTTPClient http;
char recvBuff[1024*20];

int main()
{
    int ret ;
    int i ;
#define URL_SIZE 100
    char server_url[URL_SIZE] ;

    printf("HTTP Client, Starting,...\n") ;

    eth.init(); //Use DHCP
    while(1) {
        printf("Trying to connect to Ethernet\n") ;
        if(eth.connect() == 0)break ;
    }
    printf("HTTP Client, IP Address is %s\n", eth.getIPAddress());

    while(1) {
        printf("URL(\"http://.../...\" or \"https://.../...\"):") ;
        for(i=0; i<sizeof(server_url); i++) {
            if((server_url[i] = getchar()) == '\r') {
                server_url[i] = '\0' ;
                putchar('\n') ;
                break ;
            } else putchar(server_url[i]) ;
        }

        printf("\nTrying to fetch page... %s\n", server_url);
        memset(recvBuff, '\0', sizeof(recvBuff)) ;
        ret = http.get(server_url, recvBuff, sizeof(recvBuff),16);

        if (!ret) {
            printf("Result: %s\n", recvBuff);
        } else {
            printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        }
    }

    eth.disconnect();

    while(1) {
    }
}