#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

#define HOST "192.168.1.12"

static HTTPClient http;
static char str[1024*20];
  
void main_body(void const *av) {

    char url[100] ;
    int ret ;
    //GET data

    printf("\nTrying to fetch page...\n");
    sprintf(url, "http://%s/", HOST) ;
    printf("url=%s\n",url) ;
    ret = http.get(url, str, sizeof(str)-1,16);
    if (!ret) {
        printf("Page fetched successfully - read %d characters\n", strlen(str));
        printf("Result: %s\n", str);
    } else {
        printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }

}

static EthernetInterface eth;

int main()
{
    int ret ;
    void *av ;
    printf("HTTP Client Starting,...\n") ;
    ret = eth.init(); //Use DHCP
    while(1) {
        ret = eth.connect();
        if(ret == 0)break ;
    }
    printf("IP = %s\n", eth.getIPAddress());

    main_body(av) ;

    eth.disconnect();  
    while(1) {
    }

}