#ifndef SEVENSEG_4LED_H
#define SEVENSEG_4LED_H

#define DIGITS 4
#define MASK_VALUE 0x7f
#define MASK_DOT   0x80
#define MASK_DIGIT 0x300

typedef struct {
    unsigned char val[DIGITS] ;
} SegmentValue ;

class FourDigitLED {
public:
  FourDigitLED    (
    PinName seg0, PinName seg1, PinName seg2, PinName seg3, 
    PinName seg4, PinName seg5, PinName seg6, PinName dot, 
    PinName digit0, PinName digit1, PinName digit2, PinName digit3
);
  ~FourDigitLED();
  bool attach(SegmentValue *v) ;
  void start(void) ;
  unsigned int getPtn(int d) ;
  unsigned int setPtn(int d, unsigned int ptn, unsigned int mask) ;
  int setNum(int d, int n) ;
  int setDot(int d, bool n) ;
  void test(int n) ;
  void dump(void) ;
  void scanDigit(void);

private:

    BusOut *LEDs ;
    unsigned char val[DIGITS] ;
    //Ticker Scan_tick ;
    int scan_digit ;
} ;

#endif
