#include <mbed.h>
#include <rtos.h>
#include "FourDigitLED.h"

static unsigned char SegPattern[] = {
    0x3f, 0x06, 0x5b, 0x4f, 0x66, 0x6d, 0x7d, 0x27, 0x7f, 0x6f,
    0x77, 0x7c, 0x39, 0x5e, 0x79, 0x71
};

FourDigitLED::FourDigitLED(PinName seg0, PinName seg1, PinName seg2, PinName seg3,
                           PinName seg4, PinName seg5, PinName seg6, PinName dot,
                           PinName digit0, PinName digit1, PinName digit2, PinName digit3
                          )
{
    LEDs = new BusOut( seg0, seg1, seg2, seg3, seg4, seg5, seg6, dot, digit0, digit1, digit2, digit3) ;
    scan_digit = 0 ;
    /* test LEDs */

    LEDs->write(0xfe00 | MASK_DOT | 0x0) ;
    wait(1.0) ;
    setNum(0, 8); setNum(1, 8); setNum(2, 8); setNum(3, 8);
    setDot(0, 1); setDot(1, 1); setDot(2, 1); setDot(3, 1);
    /* end test */

    wait(1.0) ;
    val[0] = 0 ; val[1] = 0 ; val[2] = 0 ; val[3] = 0 ;
}

FourDigitLED::~FourDigitLED()
{
}


void FourDigitLED::scanDigit(void)
{
    int d ;
    d= ++scan_digit ;
    d= d % DIGITS ;
    LEDs->write(~(0x100 << d) & 0xff00 | (val[d] & 0xff) ) ;
}

unsigned int FourDigitLED::getPtn(int d)
{
    if((d>=0) && (d<=sizeof(SegPattern)))
        return SegPattern[d] ;
    else
        return 0 ;
}

unsigned int FourDigitLED::setPtn(int d, unsigned int ptn, unsigned int mask)
{
    val[d] = (val[d] & 0xff80) | (ptn & mask);
    return ptn ;
}

int FourDigitLED::setNum(int d, int n)
{
    if((n <0) || (n >= 16))
        val[d] = val[d] & 0xff80 ;
    else
        val[d] = (val[d] & 0xff80) | SegPattern[n] ;
    return n ;
}

int FourDigitLED::setDot(int d, bool n)
{
    val[d] = (val[d] & 0xff7f) | ((n == false) ? 0x0 : 0x80) ;
    return n ;
}

void FourDigitLED::dump(void)
{
    printf("val = %02x, %02x, %02x, %02x\n", val[3], val[2], val[1], val[0]) ;
}
