#include "mbed.h"
#include "DigitalClock.h"
#include <algorithm>

#if 0
//Enable debug
#define DBG(x, ...) std::printf("[DigitalClock : DBG]"x"\r\n", ##__VA_ARGS__);
#define WARN(x, ...) std::printf("[DigitalClock : WARN]"x"\r\n", ##__VA_ARGS__);
#else
//Disable debug
#define DBG(x, ...)
#define WARN(x, ...)
#endif

#define ERR(x, ...) std::printf("[DigitalClock : ERR]"x"\r\n", ##__VA_ARGS__);

DigitalClock::DigitalClock (PinName seg0, PinName seg1, PinName seg2, PinName seg3, 
    PinName seg4, PinName seg5, PinName seg6, PinName dot, 
    PinName digit0, PinName digit1, PinName digit2, PinName digit3
) : 
    FourDigitLED(seg0, seg1, seg2, seg3, seg4, seg5, seg6, dot, digit0, digit1, digit2, digit3)
{
    maxHour = 24 ;
    blink   = 0 ;
    optionActive = false ;
    optionCount  = 0 ;
    updateLED    = true ;
    for(int j=0; j<AC_OPTION_NUM; j++)
        for(int i=0; i<4; i++)optVal[j][i] = 0x0 ;
} ;

DigitalClock::~DigitalClock(void){ } ;

void DigitalClock::start(void) {
    updateLED = true ;
}

void DigitalClock::stop(void) {
    updateLED = false ;
}

bool DigitalClock::setLED(int h, int m) {
    if(((h >= 0)&&(h<maxHour)) && ((m >= 0)&&(m<60))){

        setNum(3, (h/10)==0?-1:(h/10)) ; /* leading zero suppress */  
        setNum(2, h%10) ;
        setNum(1, m/10) ;
        setNum(0, m%10) ;
        return true ;
    }
    return false ;
}

void DigitalClock::flashLED(void) {
        #define JST (9*60*60)
        struct tm local;
        time_t ctTime;
        
        basePulse++ ;

        if((blink == 1) && ((basePulse%2) ==0)){
            setNum(3, -1) ; setNum(2, -1) ; setNum(1, -1) ; setNum(0, -1) ;
            return ;
        } 
        if((blink == 2) && ((basePulse%5) ==0)){
            setNum(3, -1) ; setNum(2, -1) ; setNum(1, -1) ; setNum(0, -1) ;
            return ;
        } 

        ctTime = time(NULL) + JST ;
        local  = *localtime(&ctTime);
#define SET_PTN(index) for(int i=0; i<4; i++)setPtn(i, optVal[index][i], 0x7f) ;
#define TIME_DISP (8*4)
        if(optionActive) {
            optionCount ++ ;
            if(optionCount < optNum){
                SET_PTN(optionCount) ; 
            } else {
                setLED(local.tm_hour, local.tm_min) ; 
            }
            if(optionCount > (optNum + TIME_DISP))
                optionCount = 0 ; 
        }   else setLED(local.tm_hour, local.tm_min) ;  
}


void DigitalClock::setBlink(bool sw)
{
     blink = sw ;   
}

void DigitalClock::setOptVal(const int index, const unsigned int v[], int times) {
    if(index >= AC_OPTION_NUM)return ;
    DBG("optVal[%d]=%02x,%02x,%02x,%02x\n",index, v[0], v[1], v[2], v[3]) ;
    for(int j=0; j<4; j++)optVal[index][j] = v[j] ;
    optTimes[index] = times ;
    optNum = max(optNum, index+1) ;
}

static int pollCount = 0 ;
void DigitalClock::poll(void)
{
#define PER_200mSEC(count)((count%200)==0)
#define PER_5mSEC(count) ((count%5)==0)

    pollCount++ ;
    if(updateLED && PER_200mSEC(pollCount))
        flashLED() ;
    if(PER_5mSEC(pollCount))
        scanDigit() ;
}