#ifndef DIGITALCLOCK_H
#define DIGITALCLOCK_H

#include "FourDigitLED.h"

class DigitalClock : public FourDigitLED {
public:
    DigitalClock 
       (PinName seg0, PinName seg1, PinName seg2, PinName seg3, PinName seg4, PinName seg5, PinName seg6, 
        PinName dot, PinName digit0, PinName digit1, PinName digit2, PinName digit3) ;
    ~DigitalClock();
    void start(void) ;
    void stop(void) ;
    void flashLED(void) ;
    bool setLED(int h, int min) ;
    void setBlink(bool) ;
    void setOptVal(const int index, const unsigned int v[], int times)  ;
    bool optionActive ;
    int  optionCount ;
    void poll(void) ;

private:
//    void secTick(void) ;
    int hour ;
    int min  ;
    int sec  ;
    int maxHour ;
    bool blink ;
    int basePulse ;
    bool updateLED ;

    #define AC_OPTION_NUM (16*4)
    unsigned int optVal[AC_OPTION_NUM][4] ;
    int optTimes[AC_OPTION_NUM] ;
    int optNum ;
    SegmentValue now ;
    Ticker Second ;
    FourDigitLED *led ;
} ;

#endif
