#ifndef ALARMCLOCK_H
#define ALARMCLOCK_H

#include "mbed.h"
#include "DigitalClock.h"

class AlarmClock : public DigitalClock {
public:
    AlarmClock (PinName seg0, PinName seg1, PinName seg2, PinName seg3, 
    PinName seg4, PinName seg5, PinName seg6, PinName dot, 
    PinName digit0, PinName digit1, PinName digit2, PinName digit3,
    PinName alartB, PinName hourB, PinName minB, PinName toneP
    );
    ~AlarmClock();
    bool getAlarm(int *h, int *min, int *sec) ;
    bool setAlarm(int h, int min, int sec) ;
    void alarmAhead(int sec) ;
    void alarmTone(bool) ;
    void poll(void) ;
    
private:
    DigitalIn *alarmButton ;
    DigitalIn *hourButton ;
    DigitalIn *minButton ;
    PwmOut    *tone ;

    void checkAlarmTime(void) ;
    void checkAlarmButton(void) ;
    void checkHourButton(void) ; 
    void checkMinButton(void) ; 
    void checkButtons(void);
    void checkTime(void) ;   
    time_t alarmTime ;
    bool alarmActive ;
    bool alarmB_stat ;
    bool hourB_stat ;
    bool minB_stat ;
    bool newAlarmTime ;
    bool timeMatched ;
    int  AlarmAhead ;
} ;

#endif
