#include "mbed.h"
#include "rtos.h"
#include "DigitalClock.h"
#include "AlarmClock.h"

#if 0
//Enable debug
#define DBG(x, ...) std::printf("[tokyoMetro : DBG]"x"\r\n", ##__VA_ARGS__);
#define WARN(x, ...) std::printf("[tokyoMetro : WARN]"x"\r\n", ##__VA_ARGS__);
#else
//Disable debug
#define DBG(x, ...)
#define WARN(x, ...)
#endif

#define ERR(x, ...) std::printf("[tokyoMetro : ERR]"x"\r\n", ##__VA_ARGS__);


AlarmClock::AlarmClock (PinName seg0, PinName seg1, PinName seg2, PinName seg3,
                        PinName seg4, PinName seg5, PinName seg6, PinName dot,
                        PinName digit0, PinName digit1, PinName digit2, PinName digit3,
                        PinName alarmB, PinName hourB, PinName minB, PinName toneP
                       ) :
    DigitalClock(seg0, seg1, seg2, seg3, seg4, seg5, seg6, dot, digit0, digit1, digit2, digit3)
{
    struct tm at ;
    alarmB_stat = false ;
    hourB_stat  = false ;
    minB_stat   = false ;
    alarmActive = false ;
    newAlarmTime= false ;
    optionActive= true ;
    AlarmAhead  = 0 ;
    setDot(0, optionActive) ;
        
    alarmButton = new DigitalIn(alarmB) ;
    hourButton = new DigitalIn(hourB) ;
    minButton  = new DigitalIn(minB) ;
    tone       = new PwmOut(toneP) ;

#define JST (9*60*60)
    alarmTime = time(NULL) + JST ;
    at = *localtime(&alarmTime) ;
    alarmTime -= (at.tm_hour*60*60 + at.tm_min*60) ;  /* Alarm time set to 00:00 */
}

AlarmClock::~AlarmClock() { } ;
#define ALARM_RANGE 60
#define JST (9*60*60)
void AlarmClock::checkAlarmTime(void)
{
    time_t ctTime;
    ctTime = time(NULL) + JST ;
    struct tm ct ;
    struct tm at ;
    DBG("alarmActive=%d, timeMatched=%d, ctTime=%d, alarmTime=%d\n", alarmActive, timeMatched, ctTime, alarmTime) ;
    ctTime += AlarmAhead ;
    ct = *localtime(&ctTime) ;
    at = *localtime(&alarmTime) ;
    if((ct.tm_hour <= at.tm_hour) || ((ct.tm_hour == at.tm_hour) && (ct.tm_min <= at.tm_min)))
        timeMatched = true ;
    else timeMatched = false ;
    if(alarmActive && timeMatched)
        alarmTone(true) ;
    else alarmTone(false) ;
}

static void rotateOptions(bool *alarm, bool *opt, int *count)
{
    if     ( !*alarm && !*opt) {
        *alarm = true ;
    } else if(  *alarm && !*opt) {
        *opt   = true ;
        *count = 0 ;
    } else if(  *alarm &&  *opt) {
        *alarm = false ;
    } else if( !*alarm &&  *opt) {
        *opt   = false ;
    }
}

void AlarmClock::alarmAhead(int sec) {
    AlarmAhead = sec ;
}

void AlarmClock::checkAlarmButton()
{
    struct tm * alarmT ;

    DBG("alarmB_stat=%d, alarmButton=%d", alarmB_stat, *alarmButton) ;
    if(!alarmB_stat && !*alarmButton) {
        stop() ; /* stop updating LED */
        alarmT = localtime(&alarmTime);
        DBG("Alarm Time = %d:%d\n", alarmT->tm_hour, alarmT->tm_min) ;
        setLED(alarmT->tm_hour, alarmT->tm_min) ;
        alarmB_stat = true ;
        newAlarmTime = false ;
        return ;
    } else if(alarmB_stat && *alarmButton) {
        start() ; /* show current time on LED */
        alarmB_stat = false ;
        if(!newAlarmTime)rotateOptions(&alarmActive, &optionActive, &optionCount) ;
        else             alarmActive = true ;
        DBG("alarmActive=%d\n", alarmActive) ;
        setDot(1, alarmActive) ;
        setDot(0, optionActive) ;
        flashLED() ;
    }
}

#define HOUR (60*60)
void AlarmClock::checkHourButton()
{
    struct tm * alarmT ;

    DBG("    hourB_stat=%d, hourButton=%d", hourB_stat, hourButton->read()) ;
    if((!hourB_stat && !*hourButton) && !*alarmButton) {
        alarmTime += HOUR ;
        alarmT = localtime(&alarmTime);
        setLED(alarmT->tm_hour, alarmT->tm_min) ;
        newAlarmTime = true ;
    }
}

#define MIN 60
void AlarmClock::checkMinButton()
{
    struct tm * alarmT ;

    DBG("    minB_stat=%d, minButton=%d\n", minB_stat, minButton->read()) ;
    if((!minB_stat && !*minButton) && !*alarmButton) {
        alarmTime += MIN ;
        alarmT = localtime(&alarmTime);
        setLED(alarmT->tm_hour, alarmT->tm_min) ;
        newAlarmTime = true ;
    }
}

void AlarmClock::checkButtons(void)
{
    if((alarmActive && timeMatched) && (!*alarmButton || !*hourButton || !*minButton)) {
        alarmActive = false ;
        setDot(0, alarmActive) ;
    }
    if(alarmActive && timeMatched)
        alarmTone(true) ;

    checkAlarmButton() ;
    checkHourButton() ;
    checkMinButton() ;
}

void AlarmClock::alarmTone(bool t)
{
    if(t) {
        tone->write(0.5) ;
        tone->period(0.002) ;
    } else {
        tone->write(0.0) ;
        tone->period(0.0) ;
    }
}

#define PER_SEC(count) ((count%1000)==0)
#define PER_100mSEC(count) ((count%100)==0)

static int count ;
void AlarmClock::poll(void)
{
    count++ ;
    if(PER_100mSEC(count))
        checkButtons() ;
    if(PER_SEC(count))
        checkAlarmTime() ;
    DigitalClock::poll() ;
    Thread::wait(1);
}
