#include "mbed.h"
#include <string>
#include <vector>
#include "renderclass.h"
#include "laserProjectorHardware.h"

render myRender;

InterruptIn clockEncoderPin(p14);   //blue
DigitalIn directionPin(p15);    //green

AnalogIn iny(p20);
AnalogIn inx(p19);
AnalogIn inPotX(p16);
AnalogIn inPotY(p17);

void processSerial();
//Timer timer_v;          // for shearing        //for send the speed on the serial port every 30 ms:
LocalFileSystem local("local");
//Serial pc(USBTX, USBRX);

unsigned int X, Y, T;
unsigned int beforeX , beforeY;
int startX = CENTER_AD_MIRROR_X;
int startY = CENTER_AD_MIRROR_Y;

float sint=0, cost=1;

float vx = 0, vy=0;
float theta=0, dt_betWords=50000, st=1800;
int laserColor=1, ticktime=600;
int potxx = 0,potyy = 0;


bool newPositionReady=false;
unsigned int counter=0;
vector<char> inputletters;

bool start=false;


//renderclass----------------------------------------------------------

vector<letter> alphabet;   // letter library
vector<letter> myText;

/*
string textString="H";

void createTextPoints(string& _str) {
    myText.clear();
    for (int i=0; i<_str.length(); i++) {
        myText.push_back(alphabet[(int)_str[i]-'a']);
    }
}
*/

////for culculate rotary velocity --------------------------------------------------------
int radious = 700, attachSecond = 500;
/*volatile float*/ int  angleIncrement = 1;//2.0*PI / 2500;// when in Sign/Magnitude mode

// a ticker function to compute the speed periodically-------------------------------------------------------------
#define PERIODIC_COMPUTE 5000 // in us
volatile float angularSpeed = 0;
float angleX=0.5;
float angleY=0.5;
float angleSpeedX=0;
float angleSpeedY=0;
Ticker speedTimerCompute;
Ticker superEncoder;

float PotX, PotY;


// the external interrupt routine:
void encoderClock()
{
    pc.printf("%f,%f,\n % f, %f \n\n" , PotX,PotY,angleX,angleY);
}

void computeSpeed()
{
    float oldAngleX = angleX;
    float oldAngleY = angleY;
    
    angleX = inx;
    angleY = iny;
    
    PotX = inPotX;//0.25*potxx;//
    PotY = inPotY;//0.25*potyy;//
    
    // low pass filter (recusive filter):
    float alpha=.35; // alpha=dt/(RC+dt), with dt=COMPUTE_SPEED, and f_cut=1/(2*PI*RC) is the filter cutoff frequency
                    // we want f_cut=1kHz, alpha=COMPUTE_SPEED/(1/(2.PI.fcut)+COMPUTE_SPEED) => alpha=31.415
    angleX=alpha*angleX+(1-alpha)*oldAngleX;
    angleY=alpha*angleY+(1-alpha)*oldAngleY;
    
    if(abs(angleX - oldAngleX) <0.0005 || abs(angleY - oldAngleY) < 0.0005) myRender.startSwitch=1; 
    
    angleSpeedX = -(angleX - oldAngleX) * PotX;
    angleSpeedY = -(angleY - oldAngleY) * PotY;
    
    //pc.printf("%f %f \n" ,angleX,angleY);
    //pc.printf("%f %f \n", PotX,PotY);
    
    myRender.updateSpeed(angleSpeedX,angleSpeedY);
    void processSerial();
}


int main()
{
    //read from TextFileLibrary ------------------------------------------------------
    FILE *fp = fopen("/local/text.txt", "r");
    if(!fp) {
        IO.setGreenPower(1);
        exit(1);
    }

    int letternum;
    fscanf(fp, "%d", &letternum);
    for(int i=0; i<letternum; i++) {
        letter bufl;
        fscanf(fp, "%d", &bufl.pointnum);
        for(int j=0; j<bufl.pointnum; j++) {
            point2dl bufp;
            fscanf(fp, "%d", &bufp.x);
            fscanf(fp, "%d", &bufp.y);
            fscanf(fp, "%d", &bufp.laserSwitch);
            bufl.letpoints.push_back(bufp);
        }
        alphabet.push_back(bufl);
    }


    // SETUP: --------------------------------------------------------------------------------------------
    IO.init(); // note: serial speed can be changed by checking in the hardwareIO.cpp initialization

    // initialize the angle (arbitrary origin):
    //oldAngle=angle=0;

    // Attach the external interrupt routine----------------------------------------------------------------------
    //superEncoder.attach_us(&encoderClock, 500);
    //clockEncoderPin.rise(&encoderClock);
    //clockEncoderPin.fall(&encoderClock);

    //using renderclass.cpp ----------------------------------------------------------
    //createTextPoints(textString);
    myRender.setRender(&myText);
    myRender.startRender();

    // Attach the periodic computing function:
    // We need to initialize the angleX and Y:
     angleX = inx;
    angleY = iny;
    speedTimerCompute.attach_us(&computeSpeed, PERIODIC_COMPUTE);

    // Set displaying laser powers--------------------------------------------------------------------------
    IO.setRGBPower(0);
    IO.setGreenPower(0);
    wait_ms(100);


    //timer_v.start();
    // MAIN LOOP: --------------------------------------------------------------------------------------------
    while(1) {
        if (pc.readable()>0) processSerial();
    }
}

// --------------------------------------------------------------------------------------------
// String to store ALPHANUMERIC DATA (i.e., integers, floating point numbers, unsigned ints, etc represented as DEC) sent wirelessly:
    char stringData[24]; // note: an integer is two bytes long, represented with a maximum of 5 digits, but we may send floats or unsigned int...
    int indexStringData=0;//position of the byte in the string

    void processSerial() {
        start=true;
        while(pc.readable()>0) {

            char val =pc.getc();

            // Save ASCII numeric characters (ASCII 0 - 9) on stringData:
            if ((val >= '0') && (val <= '9')) { // this is 45 to 57 (included)
                stringData[indexStringData] = val;
                indexStringData++;
            } else if ((val >= 'a') && (val <= 'z')) { // this is 45 to 57 (included)
                myText.push_back(alphabet[val - 'a']);
                //inputletters.push_back(val);
            }

            else if (val == '/') {
                myRender.stopRender();
                myRender.setRender(&myText);
                myRender.startRender();
            } else if (val == '.') {
                myRender.stopRender();
                myText.clear();
                myRender.setRender(&myText);
                //inputletters.clear();
            }

            else if (val == 'X') {
                beforeX = X;
                stringData[indexStringData] = 0;
                potxx = atoi(stringData);
                indexStringData=0;
            } else if (val == 'Y') {
                beforeY = Y;
                stringData[indexStringData] = 0;
                potyy = atoi(stringData);
                indexStringData=0;
            } else if (val == 'R') {
                stringData[indexStringData] = 0;
                myRender.laserColor = 2;
                indexStringData=0;
                //makeBuffer();
            } else if (val == 'G') {
                stringData[indexStringData] = 0;
                myRender.laserColor = 3;
                indexStringData=0;
                //makeBuffer();
            } else if (val == 'S') {
                stringData[indexStringData] = 0;
                myRender.shearingSwitch = 1 - myRender.shearingSwitch;
                pc.printf("shearingSwitch : %d \n" , myRender.shearingSwitch);
                indexStringData=0;
                //makeBuffer();
            } else if (val == 'A') {
                stringData[indexStringData] = 0;
                myRender.radious = atoi(stringData);
                pc.printf("st : %d \n" , angleIncrement);
                superEncoder.detach();
                superEncoder.attach_us(&encoderClock, attachSecond);
                indexStringData=0;
                //makeBuffer();
            } else if (val == 'T') {
                stringData[indexStringData] = 0;
                attachSecond = atoi(stringData);
                encoderClock();
                myRender.startSwitch = 1;
                /*pc.printf("attachSecond : %d \n" , attachSecond);
                
                superEncoder.detach();
                superEncoder.attach_us(&encoderClock, attachSecond);
                indexStringData=0;
                //makeBuffer();
                */
            }
            // X value?
            /*else if (val=='x') {
                stringData[indexStringData] = 0 ;
                omegaX=atoi(stringData);
                indexStringData=0;
                //newPositionReady=true;
            }
            // Y value?
            else if (val=='y') {
                stringData[indexStringData] = 0 ;
                omegaY=atoi(stringData);
                indexStringData=0;
                makeBuffer();
                newPositionReady=true;
            }

            else if (val=='g') {
                stringData[indexStringData] = 0 ;
                int power=atoi(stringData);
                indexStringData=0;
                IO.setGreenPower(power);
            } else if (val=='r') {
                stringData[indexStringData] = 0 ;
                int power=atoi(stringData);
                indexStringData=0;
                IO.setRGBPower(power);
            } else if (val=='c') {
                stringData[indexStringData] = 0 ;
                int power=atoi(stringData);
                indexStringData=0;
                IO.setRGBPower(power);
            }
            */

        }
    }