#include "mbed.h"
#include <vector>
#define PI 3.14159

#define RENDER_INTERVAL 500// in microseconds
#define WAITING_FIRST 1 // this means WAITING_FIRST number of interrupt cycles in case of the first point
#define WAITING_LAST 1

enum stateMachine{NORMAL_POINT, FIRST_POINT, AFTER_LAST_POINT};

struct point2dl {
    int x,y;
    int laserSwitch;   // laser {1: on 0:off} until next step
};

struct letter {
    int pointnum; //not used for the time being
    vector<point2dl> letpoints;
};

class render{
    public:
    void startRender();
    void setRender(vector<letter> *p);
    void translating(float speed, float angle);
    void stopRender();
    void draw();
    void transform(point2dl& mypoint);
    void shearing(point2dl& dataBefore);
    void rotation(point2dl& dataBefore);
    void updateSpeed(float vvx, float vvy);

    int shearingSwitch;
    int laserColor;
    
    int radious;
    int startSwitch;
    
    private:
    vector<letter> *ptext;
    vector<letter> translated;
    int currentLetters;
    int currentPoints;
    point2dl drawPoint;
    
    stateMachine rendererState;
    int firstPointCounter, lastPointCounter;
    
    Ticker renderTimer;
    Timer   speedTimer;
    
    float speed;
    float angle;
    float vx;
    float vy;
    float intvx,intvy;
    
    
};
