#include "renderclass.h"
#include "mbed.h"
#include "laserProjectorHardware.h"
#include <vector>

Ticker translationTimer;

//for translating -----------------------------------------------------------------

inline void render::shearing(point2dl& dataBefore)
{
    dataBefore.x = -dataBefore.x/2.0 - 10.0*intvx; //vx * speedTimer.read_us()*10; //2000000;//dataBefore.x - speed *speedTimer.read_us()/1000000 ;//- speed * cos(angle+PI/2)*speedTimer.read_us()/800;
    dataBefore.y = dataBefore.y/2.0 - 10.0*intvy; //vy * speedTimer.read_us()*10;//dataBefore.y ;//- speed * sin(angle+PI/2)*speedTimer.read_us()/800;
}

inline void render::rotation(point2dl& dataBefore)
{
    int x=dataBefore.x;
    dataBefore.x = cos(angle)*x - sin(angle)*dataBefore.y;//
    dataBefore.y = sin(angle)*x + cos(angle)*dataBefore.y;

}
//----------------------------------------------------------------------------------

void render::startRender()
{
    speedTimer.start();
    renderTimer.attach_us(this, &render::draw,RENDER_INTERVAL);
    pc.printf("render started!\n");
    pc.printf("int : %f, %f,   v :, %f,%f, " , intvx , intvy , vx , vy);
    
}

void render::stopRender()
{
    renderTimer.detach();
    speedTimer.stop();
}

void render::setRender(vector<letter> *p)
{
    translated.clear();
    radious = 200;
       
    ptext = p;
    pc.printf("Size of text to render: %d/n", (*ptext).size() );
    //for(int i=0; i!=(*ptext).size(); i++){
    int count=0;
    for(std::vector<letter>::iterator itr = (*ptext).begin(); itr != (*ptext).end(); ++itr) {
        letter translatedLetter;
        for(int i=0; i<(*itr).letpoints.size(); i++) {
            point2dl tranPoint;
            tranPoint.x=itr->letpoints[i].x+560*count;
            tranPoint.y=-itr->letpoints[i].y;
            tranPoint.laserSwitch=itr->letpoints[i].laserSwitch;
            translatedLetter.letpoints.push_back(tranPoint);
        
    }                                            //copy the liblary to the buffer.
    translated.push_back(translatedLetter);
    count++;
}

    shearingSwitch = 1;
    radious = 1800;

    currentLetters=0;

    firstPointCounter=0;
    lastPointCounter=0;

    rendererState=FIRST_POINT;
}


void render::updateSpeed(float vvx, float vvy)
{
    vx = vvx;
    vy = vvy;
    
    //intvx += RENDER_INTERVAL*vx;
    //intvy += RENDER_INTERVAL*vy;
    
    angle= 0;//(1/9.0)*PI ;//+0.3* atan( vy / vx ) * 0.7*angle;   atan2
}


void render::draw()
{
    /*
    if(firstPointCounter < 3){
        
                IO.writeOutXY(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y);
                if(laserColor % 2 == 0) IO.setRedPower(translated[currentLetters].letpoints[currentPoints].laserSwitch);
                if(laserColor % 3 == 0) IO.setGreenPower(translated[currentLetters].letpoints[currentPoints].laserSwitch);
                
        firstPointCounter+=1;
    }
    else{
        
                IO.setRedPower(0);
                IO.setGreenPower(0);
        firstPointCounter = 0;
    }
    
    
    */
    
    
    //if(abs(vx)<0.001 || abs(vy) < 0.001)startSwitch = 1;
    
    if(translated.size()>0 && startSwitch == 1) {

        switch(rendererState) {

            case NORMAL_POINT:
                intvx += speedTimer.read_us()*vx;
                intvy += speedTimer.read_us()*vy;
                speedTimer.reset();
            
                point2dl drawPoint=translated[currentLetters].letpoints[currentPoints];
                transform(drawPoint);               // transform it with the current speed and angle
                IO.writeOutXY(CENTER_AD_MIRROR_X + (int)drawPoint.x , CENTER_AD_MIRROR_Y + (int)drawPoint.y);
                if(laserColor % 2 == 0) IO.setRedPower(translated[currentLetters].letpoints[currentPoints].laserSwitch);
                if(laserColor % 3 == 0) IO.setGreenPower(translated[currentLetters].letpoints[currentPoints].laserSwitch);

                // move to the next point
                currentPoints++;

                //Should we change the state?
                if(currentPoints >= translated[currentLetters].letpoints.size() ) {
                    rendererState=AFTER_LAST_POINT;
                }
                break;

            case AFTER_LAST_POINT:
                // just wait!
                if (lastPointCounter<WAITING_LAST) {
                IO.setRedPower(0);
                IO.setGreenPower(0);
                lastPointCounter++;
                }
                else {
                    lastPointCounter=0;
                    currentPoints = 0;
                    // switch the laser off and move to the first point of the next letter:
                    
                    currentLetters++;
                    if(currentLetters >= translated.size()) {
                        currentLetters = 0;
                        //startSwitch=0;
                        intvx = intvy =0;
                        
                    
                    }
                    rendererState=FIRST_POINT;
                    
                    }
                    break;

                case FIRST_POINT:
                    
                    if (firstPointCounter<WAITING_FIRST) {
                    firstPointCounter++;
                    
                    // show first point!
                    point2dl drawPoint=translated[currentLetters].letpoints[0];
                    
                    if(currentLetters!=0){
                    intvx += speedTimer.read_us()*vx;
                    intvy += speedTimer.read_us()*vy;
                    }
                    
                    speedTimer.reset();
                    transform(drawPoint);               // transform it with the current speed and angle
                    IO.writeOutXY(CENTER_AD_MIRROR_X + (int)drawPoint.x , CENTER_AD_MIRROR_Y + (int)drawPoint.y);
                    
                    
                    
                    //IO.setRedPower(translated[currentLetters].letpoints[currentPoints].laserSwitch);

                    } else {
                        firstPointCounter=0;
                        currentPoints=1;
                        
                        intvx += speedTimer.read_us()*vx;
                        intvy += speedTimer.read_us()*vy;
                        speedTimer.reset();
                        
                        rendererState=NORMAL_POINT;
                    }
                    break;
                }
        }
    
}

    void render::transform(point2dl& mypoint) {
        rotation(mypoint);
        if(shearingSwitch == 1) shearing(mypoint);
}

