#include "mbed.h"
#include "Websocket.h"
#include "TextLCD.h"

#define WS_SERVER_URL "ws://sockets.mbed.org/ws/webdbpress/rw"

Websocket *ws;
TextLCD lcd(p24, p26, p27, p28, p29, p30);
AnalogIn ain(p15);
float temp;

int main() {
    int i = 0;
    char buf[512];
    Timer timer;

    lcd.printf("init network...\n");
    ws = new Websocket(WS_SERVER_URL);

    lcd.printf("connecting...\n");
    while(!ws->connect()) {
        printf("retrying...\r\n");
        wait(5);
    }

    timer.start();
    while(1) {
        Net::poll();
        wait(0.1);

        if (timer.read_ms() >= 10000) {
            temp = ain * 3.3 * 100;
            sprintf(buf, "No.%d: temp:%4.2f", i++, temp);
            ws->send(buf);
            timer.reset();
        }
        
        if (ws->read(buf)) {
            lcd.cls();
            lcd.printf("recv: %s\n", buf);
        }

        if (! ws->connected()) {
            lcd.cls();
            lcd.printf("disconnected\n");
            break;
        }
    }
}
