/**
 *  VaporConditions Vepor related calculation library 
 *
 *  @author  Takafumi Naka
 *  @version 1.0
 *  @date    30-Apr-2015
 *
 *  Library for Calculate some vapor related values from Temperature, Relative Humidity and Air Pressure
 *  The formulas are based on 
 *  http://www.mistral.co.jp/kestrel-japan/MistralHumiRatio.pdf
 *  http://www.kanomax.co.jp/img_data/file_731_1417598330.pdf
 */
 
#include "mbed.h"
#include "math.h"
#include "VaporCondition.h"

// Saturated Vapor Pressure (hPa) //
float VaporCondition::Pvsat()
{
    return (6.11*pow(10,7.5*t/(t+237.3))); 
}

// Vapor Pressure (hPa) //
float VaporCondition::Pv()
{
    return (Pvsat()*h/100.);
}

// Humidity Ratio (g/kg) //
float VaporCondition::Rh()
{
    return (6.22*Pv()*100/p);
}

// Dew Point Temperature //
float VaporCondition::Tdp()
{
    float y,y2,y3,y4;
    y = log(Pv()*100/611.213);
    y2 = y*y;
    y3 = y2*y;
    y4 = y2*y2;
    if ( y>=0 ) 
    {
        return (13.715 * y+ 8.4262e-1 * y2 +1.9048e-2 * y3 +7.8158e-3 * y4);
    }
    else
    {
        return (13.7204 * y +7.36631e-1 * y2 +3.32136e-2 * y3 +7.78591e-3 * y4);
    }
}