/**
 *  VaporConditions Vepor related calculation library 
 *
 *  @author  Takafumi Naka
 *  @version 1.0
 *  @date    30-Apr-2015
 *
 *  Library for Calculate some vapor related values from Temperature, Relative Humidity and Air Pressure
 *  The formulas are based on 
 *  http://www.mistral.co.jp/kestrel-japan/MistralHumiRatio.pdf
 *  http://www.kanomax.co.jp/img_data/file_731_1417598330.pdf
 */
 
#ifndef Vapor_Condition_H
#define Vapor_Condition_H

#include "mbed.h"
#include "math.h"

class VaporCondition
{
public:
    float t; // Temperature (degC) // 
    float h; // Relative Humidity (%) //
    float p; // Air Pressure (hPa) //

    /* Saturated vapor pressure */ 
    float Pvsat(void); 
    float Pv(void);
    float Rh(void);
    float Tdp(void);

private:
};


#endif // Vapor_Condition_H

 