//**********************
// こて先温度計：Soldering Iron Tips Thermometer with MAX31855K
//
// こて先温度計シールド:Thermocouple Shield for Soldering Iron
//      https://www.switch-science.com/catalog/2322/
//      3.3V用にSJ1, SJ2をショートして使用しています
//      It is the shield with MAX31855K and K-type thermocouple. 
//  
// Universal Embedded Board for LPC11U68 by HAPI-TechSolution
//      https://www.switch-science.com/catalog/2316/
//
// I2C接続の小型LCD搭載ボード(3.3V版): 8x2 LCD display
//      https://www.switch-science.com/catalog/1405/
//      8x2 LCD with AQM0802 controller
//
//**********************
#include "mbed.h"
#include "AQM0802.h"
#include "max31855.h"

#define NEED_CONSOLE_OUTPUT 0
#define NEED_LCD_OUTPUT 1

#if NEED_CONSOLE_OUTPUT
Serial  pc(USBTX, USBRX);
#define PC(...) { pc.printf(__VA_ARGS__); }
#else
#define PC(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */

I2C i2c(SDA, SCL);
SPI spi(P0_9, P0_8, P1_29);
max31855 max1(spi, P0_2);

#if NEED_LCD_OUTPUT
AQM0802 lcd(i2c);
#endif

int main()
{
    char msg1[10],msg2[10];
    float fvalue;
    float chiptemp;
    int faultCode;

    //Initialise chip (starts internal timer)
    max1.initialise();
    wait(2);
    
    sprintf(msg1,"Temp");
    fvalue = max1.read_temp();
    wait_ms(500);
        
    while(1){  
            fvalue = max1.read_temp();
            PC("%d\n",fvalue);
            
            if (fvalue > 2000.){
                faultCode = fvalue - 2000;
                if((faultCode & 4 ) != 0){
                    sprintf(msg2,"Short Vc");
                    PC("ERROR: Short to VCC");
                }else if((faultCode & 2 ) != 0){
                    sprintf(msg2,"Short G ");
                    PC("ERROR: Short to GND");
                }else if((faultCode & 1 ) != 0){
                    PC("ERROR: Open Circuit");
                    sprintf(msg2,"Open    ");
                }
            } else {
                sprintf(msg2,"%6.2f%cC",fvalue,0xf2);
            }
            
            chiptemp = max1.chipTemp * 0.25;
            // sprintf(msg1,"%6.2f%cC",chiptemp,0xf2);
            
            PC("%7.2f : %7.2f\n",fvalue, chiptemp);
      
#if NEED_LCD_OUTPUT
            lcd.locate(0,0);
            lcd.print(msg1);
            lcd.locate(0,1);
            lcd.print(msg2);

#endif
            wait_ms(500);
    }

}