//**********************
// Hygrometer and Thermometer for mbed
//
// LPC1768 flash=512KB, ADC=12bits
// LPC11U35 flash=64KB, ADC=10bits
// Nucleo ADC=12bits
//
// (C)Copyright 2015 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#include "mbed.h"
#include "HDC1000.h"
#include "BME280.h"
#include "AQM0802.h"

#include "VaporCondition.h"

#define NEED_CONSOLE_OUTPUT 1
#define NEED_LCD_OUTPUT 1

#if NEED_CONSOLE_OUTPUT
Serial  pc(USBTX, USBRX);
#define PC(...) { pc.printf(__VA_ARGS__); }
#else
#define PC(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */


#if defined(TARGET_LPC1768)
    I2C i2c(p28, p27);
    // BME280 sensor(p28, p27, 0x76 << 1);
#else
    I2C i2c(I2C_SDA0, I2C_SCL0);
    // BME280 sensor(I2C_SDA0, I2C_SCL0, 0x76 << 1);
#endif

BME280 bme280(I2C_SDA0, I2C_SCL0, 0x76 << 1);
HDC1000 hdc1000(i2c);
#if NEED_LCD_OUTPUT
    AQM0802 lcd(i2c);
#endif

DigitalOut led1(LED1);
DigitalOut led2(LED2);


int main() {
    float Tdp_o =0.;
    float Tdp_i =0.;
    int cautions = 0;
    int warnings = 0;
    int warn_wid = 20;
    char msg1[10],msg2[9];
    int mode=0;
    int skip=0;
    char msg[4][2][9];
    int skipf[4];
    
    float Tcur;
    float Tdp;
    char *sTcur;
    char *sWin;
    char *ssTcur;
    char *ssWin;
   
    VaporCondition Inside;
    VaporCondition Outside;

    // LED Check       
    led1 = 1;
    led2 = 1;
    wait(3);

    led1 = 0;
    led2 = 0;
    
    // i2c.frequency(100000);
      
    while(1) {
        // Get data

        Outside.t = bme280.getTemperature();
        Outside.h = bme280.getHumidity();

        Outside.p = bme280.getPressure();
        Inside.p = bme280.getPressure(); // Usually Pressures are same between inside and outside.

        Inside.t = float(hdc1000.temperature())/0x10000*165-40;
        Inside.h = float(hdc1000.humidity())/0x10000*100;

//                PC("%2.2f degC, %2.2f %%\r\n", t, h);

        PC("In: %2.2f degC, %2.2f %% Out: %2.2f degC, %2.2f %%, %04.2f hPa\r\n", Inside.t, Inside.h, Outside.t, Outside.h, Outside.p);
        PC("Humidity Ratio [g/kg] : In %2.2f Out %2.2f \r\n", Inside.Rh(), Outside.Rh());
        Tdp_o = Outside.Tdp();
        Tdp_i = Inside.Tdp();
        PC("Due Point Temperature [degC] : In %2.2f Out %2.2f \r\n", Tdp_o, Tdp_i);

        // print catuions and warnings //
        cautions = 0;
        warnings = 0;

        for(int ii=0; ii<4; ii++) {
            if ( (ii % 2) == 1 ) {
                Tcur = Outside.t;   // 1 and 3
                sTcur = "Outside";
                ssTcur = "Out";
            } else {
                Tcur = Inside.t;    // 0 and 2
                sTcur = "Inside";
                ssTcur = "In";
            }

            if ( ii / 2 ) {
                sWin = " Window"; // 2 and 3
                ssWin = "@Win";
            } else {
                sWin = "";         // 0 and 1
                ssWin = "";
            }

            if ( ii / 2 == ii %2 ) {
                Tdp = Tdp_i;    // 0 and 3
            } else {
                Tdp = Tdp_o;    // 1 and 1
            }

            if ( Tdp >= Tcur - warn_wid ) {
                skipf[ii] = 0;
                if ( Tdp >= Tcur ) {
                    PC("Condensation at %s\r\n",sTcur);
                    sprintf(msg[ii][0],"Condns!!");
                    sprintf(msg[ii][1],"%s%s",ssTcur,ssWin);
                    cautions ++;
                } else {
                    PC("%2.2f degC to Condensation at %s%s\r\n", Tcur - Tdp, sTcur, sWin);
                    sprintf(msg[ii][0],"Cto%4.1fC",Tcur-Tdp);
                    sprintf(msg[ii][1],"%s%s\0",ssTcur,ssWin);
                    warnings ++;
                }
            } else {
                skipf[ii] = 1;
            }
        }

        PC("\r\n");

        if ( cautions > 0 ) {
            led2 = 1;
        } else {
            led2 = 0;
        }

        if ( warnings > 0 ) {
            led1 = 1;
        } else {
            led1 = 0;
        }

        // LCD print
        switch(mode) {
            case (0):
                skip = 1;
                break;
 
            case (1):
                sprintf(msg1,"Ti %4.1fC",Inside.t);
                sprintf(msg2,"To %4.1fC",Outside.t);
                break;
                
            case (2):
                sprintf(msg1,"Hi %4.1f%%",Inside.h);
                sprintf(msg2,"Ho %4.1f%%",Outside.h);
                break;
                
            case (3):
                sprintf(msg1,"Po%6.2f",Outside.p);
                sprintf(msg2,"   [hPa]");
                break;
                
            case (4):
                sprintf(msg1,"Dpi%4.1fC",Tdp_i);
                sprintf(msg2,"Dpo%4.1fC",Tdp_o);
                break;
                
            case (5):
            case (6):
            case (7):
            case (8):
                int ii = mode - 5;
                skip = skipf[ii];
                sprintf(msg1,"%8s",msg[ii][0]);
                sprintf(msg2,"%8s",msg[ii][1]);
                break;
        }
        mode++;
        if ( mode > 8 ) {
                mode = 0;
        } 
        
        if ( skip == 0 ) {
#if NEED_LCD_OUTPUT
            lcd.locate(0,0);
            lcd.print(msg1);
            lcd.locate(0,1);
            lcd.print(msg2);
#endif
        
            wait(3);
        } else {
            skip = 0;
        }
    }

}