/*
AS3935_ext.cpp - AS3935 Franklin Lightning Sensor™ IC by AMS library
Copyright (c) 2015 T.Naka. All rights reserved.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 3 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "AS3935_ext.h"

AS3935_ext::AS3935_ext(PinName sda, PinName scl, int adresse, PinName irqin): AS3935(sda, scl ,adresse)
{
    irq = irqin;
    wait_ms(11);
}

void AS3935_ext::reset()
{

    AS3935::reset();
    
    // Callibrate automatically the internal RCO Oscillators 
    registerWrite(0x3D,0xff,0x96);
    wait_ms(2);
    
    // Minimum number of lightning
    registerWrite(AS3935_MIN_NUM_LIGH ,1);
    
}

int AS3935_ext::MeasureLCOFreq()
{
    DigitalIn display(irq);
    int t0;
    int t1;
    float hz;
    unsigned int ticks_per_second;
    // int d;
#define LFCLK_FREQUENCY 0x8000
#define RTC_COUNTER_SIZE 0x1000000
    ticks_per_second = LFCLK_FREQUENCY / (NRF_RTC1->PRESCALER + 1);

    // Set LCO_FDIV as 32 (0x3) (multiply 128)
    wait_ms(20);
    registerWrite(AS3935_LCO_FDIV,0x3);

    // Enable display LCO on IRQ
    wait_ms(20);
    registerWrite(AS3935_DISP_LCO,1);
    
    wait_ms(100);

    // Wait until IRQ becomes low;
    while(display.read() == 1)

    // Wait until IRQ becomes high
    wait_ms(20);
    while(display.read() == 0);
    t0 = NRF_RTC1->COUNTER;

    for(int i=0;i<1000;i++) {
        // Wait until IRQ becomes low
        while(display.read() == 1);

        // Wait until IRQ becomes high;
        while(display.read() == 0);
    }
    t1 = NRF_RTC1->COUNTER;
    // printf("%d\r\n",t1-t0);

    // 1000*128/500k = 0.256sec
    hz = 1000* 128 * ticks_per_second / (unsigned int)((t1 - t0 + RTC_COUNTER_SIZE) % RTC_COUNTER_SIZE);

    // Disable display LCO on IRQ pin;
    registerWrite(AS3935_DISP_LCO,0);

    return(hz);
}
