/*
AS3935_ext.h - AS3935 Franklin Lightning Sensor™ IC by AMS library
Copyright (c) 2015 T.Naka. All rights reserved.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 3 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef _AS3935_EXT_HPP
#define _AS3935_EXT_HPP

#include "mbed.h"
#include "AS3935.hpp"

class AS3935_ext : public AS3935 {
    private:
        PinName irq;
        
    public:
        AS3935_ext(PinName sda, PinName scl, int adresse, PinName irq);

        int MeasureLCOFreq();
        void setIRQ(PinName irqpin);
        void reset();


};

/* !_AS3935_EXT_HPP */
#endif