#ifndef HCSR04_H
#define HCSR04_H

#include "mbed.h"



/*
Sonar HC-SR04 exemple de code.

@code
#include "mbed.h"
#include "HCSR04.h"

Serial pc(USBTX,USBRX);     

HCSR04 sonar(PG_2, PG_3); //trigger, echo

int main() {
    while(1) {
        printf("Distance mesuree: %f cm \n", sonar.Distance_Cm()); 
        wait_ms(1000);
    }
}
 
@endcode
*/

class HCSR04 {    
    public:    
        //////////// Constructeur, creation de l'instance HCSR04 ////////////
        HCSR04(PinName trigger, PinName echo);
 
 
 
        //lancement du protocole de mesure  et renvoie la valeur en us du temps a l'etat 1 de echo
        float Lecture_Echo(void);
        
        // mesure et renvoie de la distance en cm
        float Distance_Cm(void);
        
    private:
        float temps_echo;   //temps d'activation de echo
        float dist_cm;       //valeur de la distance en cm
        
        DigitalOut _t;      //configuration de la broche trigger
        DigitalIn _e;       //Configuration de la broche echo
        Timer _temps;       //création de l'objet temps
        
};

#endif