#include "HCSR04.h"
#include "mbed.h"


HCSR04::HCSR04(PinName trigger, PinName echo) : _t(trigger), _e(echo) {
    wait(0.1);
    }

float HCSR04::Distance_Cm(void){
    dist_cm = Lecture_Echo()/58;
    return dist_cm;
    }

float HCSR04::Lecture_Echo(void){ 
       
    _t=1;                       //initialisation du trigger
    wait_us(10);                //10us d'impulsion
    _t=0;                       //mise à 0 du trigger
    while(!_e){
        // si pas de signal recu sur echo alors on relance le trigger
        _t=1;                       
        wait_us(10);                
        _t=0;                       
    }
    _temps.start(); // lancement du timer
    while(_e){
        // on attend la remise a 0 de echo pour pouvoir calculer la distance
    }
    temps_echo = _temps.read_us();   //Lecture du timer
    _temps.stop();              //arret du timer
    _temps.reset();             //Remise a 0 du timer
    
    
    return temps_echo;
}