#include "mbed.h"
#include "uLCD_4DGL.h"


// Analog input (pin 15)
AnalogIn ain(p15);
AnalogIn ain2(p16);

// USB serial (tx, rx)
Serial pc(USBTX, USBRX);

// TX, RX, and RES pins
uLCD_4DGL uLCD(p9,p10,p11);

void Temperature();
void TempConstraints();
float getTemp();
float avgTemp();
float getTemp2();
float avgTemp2();

float voltage_in;
float degrees_c;
float avgT;
float Temp;
float a;
float b;
    
int main() {
    

    // Collect temperatures with timestamps every second
    while(1) {
        uLCD.cls();
        uLCD.printf("Temperature:\n\n");

        Temperature();
        wait(10);
        }
}

void Temperature(){

    a = avgTemp();
    b = avgTemp2();

    TempConstraints();
    
    uLCD.text_width(2);
    uLCD.text_height(2);
    Temp = (a + b)/2;
    pc.printf("%3.1f deg C\n\r", Temp);
    uLCD.printf("%3.1f \t", Temp);
    uLCD.text_width(1);
    uLCD.text_height(1);
    uLCD.printf("o");
    uLCD.text_width(2);
    uLCD.text_height(2);
    uLCD.printf("C");
}

void TempConstraints() {

    if(degrees_c <= 4){
        pc.printf("WARNING\nCOLD TEMPERATURES\nICE MAY BE PRESENT");
    }
    if(abs(a-b) > 4){
        uLCD.printf("WARNING\nTEMPERATURE SENSOR\nFAULT\n");
    }
}  

float getTemp(){
    voltage_in = ain * 3.3;
    degrees_c = ((voltage_in - 0.5) * 100.0);
    return degrees_c;
}

float getTemp2(){
    voltage_in = ain2 * 3.3;
    degrees_c = ((voltage_in - 0.5) * 100.0);
    return degrees_c;
}

//Thsi function obtaines the voltage from the first sensor
float avgTemp(){
    float a = getTemp();
    float b = getTemp();
    float c = getTemp();
    float d = getTemp();
    float e = getTemp();
    float f = getTemp();
    float g = getTemp();
    float h = getTemp();
    float i = getTemp();
    float j = getTemp();
    float k = getTemp();
    float l = getTemp();
    float m = getTemp();
    float n = getTemp();
    float o = getTemp();
    float p = getTemp();
    float q = getTemp();
    float r = getTemp();
    float s = getTemp();
    float t = getTemp();
    
    //The function is called to get 20 Values of the required voltage in order
    //to acieve an accurate resuilt and eliminate outlier effects
    avgT = (a+b+c+d+e+f+g+h+i+j+k+l+m+n+o+p+q+r+s+t)/20;
    
    return avgT;
}

//this function obtaines the voltage from the second sensor
float avgTemp2(){
    float a = getTemp2();
    float b = getTemp2();
    float c = getTemp2();
    float d = getTemp2();
    float e = getTemp2();
    float f = getTemp2();
    float g = getTemp2();
    float h = getTemp2();
    float i = getTemp2();
    float j = getTemp2();
    float k = getTemp2();
    float l = getTemp2();
    float m = getTemp2();
    float n = getTemp2();
    float o = getTemp2();
    float p = getTemp2();
    float q = getTemp2();
    float r = getTemp2();
    float s = getTemp2();
    float t = getTemp2();
    
    avgT = (a+b+c+d+e+f+g+h+i+j+k+l+m+n+o+p+q+r+s+t)/20;
    
    return avgT;
}



