#include "mbed.h"
#include "hcsr04.h"
#include "Speaker.h"
#include "uLCD_4DGL.h"

//Temperature Inputs
AnalogIn ain(p15);
AnalogIn ain2(p16);

//Distance Inputs
HCSR04  distSens(p25,p6);
Speaker mySpeaker(p18);

//Initialisation of LCD and Serial Monitor
Serial pc(USBTX, USBRX);
uLCD_4DGL uLCD(p9,p10,p11);

//Autolights Inputs
AnalogIn photodiode(p20);
PwmOut myled(p21);

//Distance
unsigned int dist;
float averageDistance();
void beeping();
float i;
float x = 0;

//Temperature
void Temperature();
void TempConstraints();
float getTemp();
float avgTemp();
float getTemp2();
float avgTemp2();
float voltage_in;
float degrees_c;
float avgT;
float Temp;
float a;
float b;

//Autolights
void LED();
 
int main()
{
    //distance
    uLCD.text_width(1);
    uLCD.text_height(1);
    uLCD.locate(10, 12);
    uLCD.color(BLUE);
    uLCD.printf(" Reverse           Sensor");
    uLCD.rectangle(65, 117, 126, 127, 0x0000FF);
     
    while(1) {
        i++;
        //distance
        distSens.start();
        averageDistance();
        beeping();
        uLCD.filled_rectangle(66, 118, 125, 127, 0x000000);
        pc.printf("cm:%d\n",dist );
        uLCD.locate(10, 15);
        uLCD.color(WHITE);
        uLCD.printf("cm:%1d\n",dist );
        //temperature
        Temperature();
        //autolights
        LED();
    }
}
//measure average distance from sensor
float averageDistance()
{
        int a = distSens.get_dist_cm();
        int b = distSens.get_dist_cm();
        int c = distSens.get_dist_cm();
        int d = distSens.get_dist_cm();
        int e = distSens.get_dist_cm();
        int f = distSens.get_dist_cm();
        int g = distSens.get_dist_cm();
        int h = distSens.get_dist_cm();
        int i = distSens.get_dist_cm();
        int j = distSens.get_dist_cm();
 
        dist  = (a+b+c+d+e+f+g+h+i+j)/10;
        return dist;
}
//distance parameters and output
void beeping()
{
    int distance = averageDistance();
    //sensor defaults to 2k+ when dist<~3cm 
    if (distance > 2000) i=1.5; 
    if (distance < 150) i=0.3;
    if (distance < 100) i=0.35;
    if (distance < 90) i=0.4;
    if (distance < 80) i=0.45;
    if (distance < 70) i=0.5;
    if (distance < 60) i=0.55;
    if (distance < 50) i=0.6;
    if (distance < 40) i=0.65;
    if (distance < 30) i=0.7;
    if (distance < 20) i=0.8;
    if (distance < 10) i=1;
    if (distance < 5) i=1.2;
    mySpeaker.PlayNote(700*i, 0.2, 2*i);  
}
//measure and output temperature
void Temperature(){
    uLCD.locate(1,1);
    uLCD.printf("Temperature:\n\n");
    a = avgTemp();
    b = avgTemp2();
    Temp = ((a + b)/2)-15;
    uLCD.text_width(2);
    uLCD.text_height(2);
    uLCD.printf("%3.1f\t", Temp);
    uLCD.text_width(1);
    uLCD.text_height(1);
    uLCD.printf("o");
    uLCD.text_width(2);
    uLCD.text_height(2);
    uLCD.printf("C");
    uLCD.text_width(1);
    uLCD.text_height(1);
    TempConstraints();
}
 //signal sensor fault or low temperature
void TempConstraints() {
    if(degrees_c <= 4){
        uLCD.text_width(1);
        uLCD.text_height(1);
        uLCD.locate(1,5);
        pc.printf("ICE WARNING");
    }
    if(abs(a-b) > 4){
        uLCD.text_width(1);
        uLCD.text_height(1);
        uLCD.locate(1,5);
        uLCD.printf("TEMPERATURE FAULT");
    }
}  
//convert sensor outut to temperature
float getTemp(){
    voltage_in = ain * 3.3;
    degrees_c = ((voltage_in - 0.5) * 100.0);
    return degrees_c;
}
float getTemp2(){
    voltage_in = ain2 * 3.3;
    degrees_c = ((voltage_in - 0.5) * 100.0);
    return degrees_c;
}
//Thsi function obtaines the average voltage from the first sensor
float avgTemp(){
    float a = getTemp();
    float b = getTemp();
    float c = getTemp();
    float d = getTemp();
    float e = getTemp();
    float f = getTemp();
    float g = getTemp();
    float h = getTemp();
    float i = getTemp();
    float j = getTemp();
    float k = getTemp();
    float l = getTemp();
    float m = getTemp();
    float n = getTemp();
    float o = getTemp();
    float p = getTemp();
    float q = getTemp();
    float r = getTemp();
    float s = getTemp();
    float t = getTemp();
    
    avgT = (a+b+c+d+e+f+g+h+i+j+k+l+m+n+o+p+q+r+s+t)/20;
    return avgT;
}
float avgTemp2(){
    float a = getTemp2();
    float b = getTemp2();
    float c = getTemp2();
    float d = getTemp2();
    float e = getTemp2();
    float f = getTemp2();
    float g = getTemp2();
    float h = getTemp2();
    float i = getTemp2();
    float j = getTemp2();
    float k = getTemp2();
    float l = getTemp2();
    float m = getTemp2();
    float n = getTemp2();
    float o = getTemp2();
    float p = getTemp2();
    float q = getTemp2();
    float r = getTemp2();
    float s = getTemp2();
    float t = getTemp2();
    
    avgT = (a+b+c+d+e+f+g+h+i+j+k+l+m+n+o+p+q+r+s+t)/20;
    return avgT;
}
//check LED and turn on and off lights as required
void LED(){
    if (photodiode*100 <= 27){
        myled = 1; 
        uLCD.locate(1,7);
        uLCD.printf("Autolights:\n\n"); 
        uLCD.text_width(2);
        uLCD.text_height(2);
        uLCD.printf("ON ");
        uLCD.text_width(1);
        uLCD.text_height(1);
    } else {
        myled = 0;
        uLCD.locate(1,7);
        uLCD.printf("Autolights:\n\n"); 
        uLCD.text_width(2);
        uLCD.text_height(2);
        uLCD.printf("OFF");
        uLCD.text_width(1);
        uLCD.text_height(1);
    } 
}