/*
    maple_motores.cpp
    este programa usa el driver tb6612 para controlar 2 motores DC
    se puede usar cualquier driver similar, como el l293D o el l298n
    inicializar la clase MotoresDC de la siguiente manera:
    
        MotoresDC motores(vel_izq, s_izq1, s_izq2, vel_der, s_der1, s_der2);
    
*/
#include "mbed.h"
#include "motoresDC.h"

//(Maple Mini)
//motores       D27   D31    D30    D26   D29    D28     
MotoresDC carro(PA_8, PB_12, PB_13, PA_9, PB_14, PB_15);
//                    D32
InterruptIn my_button(PB_8);
//         D33      
PwmOut led(PB_1);

//-----------------
float velocidad = 0;
int estado= 0;
//-----------------
void pressed() {
    estado++;
    if(estado > 9) estado = 0;
}

int main()
{   
    // Set button
    //my_button.fall(&pressed);
    
    while (1) {
        carro.conducir(0.5,1000);
        carro.conducir(-0.5,1000);
        carro.pivotar(0.5,1000);
        carro.pivotar(-0.5,1000);
        carro.motorIzq(0.5,1000);
        carro.motorDer(0.5,1000);
        carro.motorIzq(-0.5,1000);
        carro.motorDer(-0.5,1000);
        carro.detener();
        wait(1);
    }
}
