#define MAPLE_MINI
#include "pines.h"
#include "mbed.h"
#include <HMC5883L.h>
#include <RF24Network.h>
#include <RF24.h>
#include <motoresDC.h>

Serial pc(TX3_PIN, RX3_PIN);
HMC5883L brujula;
InterruptIn boton(PB_8);

//motores       D27   D31    D30    D26   D29    D28     
MotoresDC carro(PWM_L, CTRL1_L, CTRL2_L, PWM_R, CTRL1_R, CTRL2_R);

PwmOut led(PB_1);
DigitalOut status(PB_2);

RF24 radio(spi_MOSI, spi_MISO, spi_SCK, nrf_CE, nrf_CSN );

// Network uses that radio
RF24Network network(radio);

// Address of our node
const uint16_t this_node = 01;
// Address of the other node
const uint16_t other_node = 00;
// How often to send payload packet to the other unit
const unsigned long interval = 100; //ms
// When did we last send?
unsigned long last_sent;
Timer t;
// How many have we sent already
unsigned long packets_sent;
Timer t_packet;
// Structure of our payload
struct payload_t 
{
    unsigned long ms;
    unsigned long counter;
    double heading;
};

volatile double heading;
volatile unsigned int flag = 0;
// functions
void toggle(void)
{
    flag = 1;
    heading = brujula.getHeading();
}

void initP()
{
    led = 1;
    boton.fall(toggle);
    brujula.init();
    carro.conducir(1);
    wait_ms(1000);
    carro.conducir(0);
    led = 0;
    wait_ms(500);
    led = 1;
    radio.begin();
    network.begin(/*channel*/ 90, /*node address*/ this_node);
    carro.conducir(-1);
    wait_ms(2000);
    t.start();
    t_packet.start();
    status = 0;
    led = 0;
    carro.conducir(0);
}

void checkMessage()
{
    while ( network.available() ) 
        {
            // If so, grab it and print it out
            RF24NetworkHeader header_rx;
            payload_t payload_rx;
            network.read(header_rx,&payload_rx,sizeof(payload_rx));
            carro.conducir(payload_rx.heading / 360.0);
            status = abs(payload_rx.heading) < 5.0 ? 1 : 0;
        }
}
//------

bool sendMessage(double angulo)
{
    led = !led;
            t.reset();

            payload_t payload_tx;
            payload_tx.ms = t_packet.read_ms();
            payload_tx.counter = packets_sent++;
            payload_tx.heading = angulo;
            
            RF24NetworkHeader header_tx(/*to node*/ other_node);
            bool ok = network.write(header_tx,&payload_tx,sizeof(payload_tx));    
            flag = 0;
            led = 0;     
            return ok;
}    
int main()
{   
    initP();
    
    
    while(1) 
    {
        // Pump the network regularly
        network.update();
        checkMessage();
        /* If it's time to send a message, send it! */
        double angulo = brujula.getHeading();
        led = angulo / 360.0;
        unsigned long now = t.read_ms();
        if ( (now - last_sent) > interval  ) 
        {
            last_sent = now;
            bool ok = sendMessage(angulo);
        }
        
        /*
        if(abs(angulo) < 4)
        {
            led = 1;
        }
        else
        {
            led = 0;
        }
        */
    }

}