#ifndef LAKE_ACT_H_
#define LAKE_ACT_H_

#include "mbed.h"
#include "Process.h"
#include "../Using.h"
#include "../../LED/LED.h"
#include "../../Safty/Safty.h"
#include "../../Input/Switch/Switch.h"
#include "../../Communication/RS485/ActuatorHub/ActuatorHub.h"
#include "../../Communication/Controller/Controller.h"

using namespace LED;
using namespace ACTUATORHUB;
using namespace ACTUATORHUB::MOTOR;
using namespace ACTUATORHUB::SOLENOID;
using namespace SAFTY;
using namespace CONTROLLER;
using namespace SWITCH;

extern MotorStatus motor[MOUNTING_MOTOR_NUM];

namespace LAKE_ACTUATOR
{
    #define HEIGHT_FR motor[0]
    #define HEIGHT_FL motor[1]
    #define HEIGHT_RL motor[2]
    #define HEIGHT_RR motor[3]

    #define HEIGHT_SW_FR LimitSw::IsPressed(0)
    #define HEIGHT_SW_FL LimitSw::IsPressed(1)
    #define HEIGHT_SW_RL LimitSw::IsPressed(2)
    #define HEIGHT_SW_RR LimitSw::IsPressed(3)

    class user
    {
        public:
        static uint8_t setStatus(signed int pwmVal);
        static uint8_t setStatus_f(signed int pwmVal);
        static uint8_t setPWM(signed int pwmVal);
        static MotorStatus MakeMotorStatus(int16_t ctrlPWM);
        static MotorStatus MakeMotorStatus_f(int16_t ctrlPWM);
    };

    class Lake_Height
    {
        public:
        enum class Position
        {
            Bottom,
            Bottom_Middle,
            Middle,
            Middle_Top,
            Top
        };

        enum class State
        {
            Climb,
            Descent,
            Stop
        };

        void SetPosition(Position requestPos);
        Position GetPosition();
        void Update();
        void Stop();

        private:
        Position pos_;
        State state_;
        
        void UpPos();
        void DownPos();
    };
}

#endif
