#include "Lake_act.h"

namespace LAKE_ACTUATOR
{
    uint8_t user::setStatus(signed int pwmVal)
    {
        if(pwmVal < 0)  return FOR;
        else
        if(pwmVal > 0)  return BACK;
        else
        if(pwmVal == 0) return BRAKE;
    }

    uint8_t user::setStatus_f(signed int pwmVal)
    {
        if(pwmVal < 0)  return FOR;
        else
        if(pwmVal > 0)  return BACK;
        else
        if(pwmVal == 0) return FREE;
    }
    
    uint8_t user::setPWM(signed int pwmVal){
        uint8_t makePWM;
        if(pwmVal == 0 || pwmVal > 255 || pwmVal < -255)
        makePWM = 255;
        else    makePWM = abs(pwmVal);
        return  makePWM;
    }

    MotorStatus user::MakeMotorStatus(int16_t ctrlPWM) {
        MotorStatus make;
        make.dir = setStatus(ctrlPWM);
        make.pwm = setPWM(ctrlPWM);
        return make;
    }

    MotorStatus user::MakeMotorStatus_f(int16_t ctrlPWM) {
        MotorStatus make;
        make.dir = setStatus_f(ctrlPWM);
        make.pwm = setPWM(ctrlPWM);
        return make;
    }

    void Lake_Height::Update() {
        if(pos_ != Position::Bottom_Middle && pos_ != Position::Middle_Top) {
            HEIGHT_FR = user::MakeMotorStatus(0);
            HEIGHT_FL = user::MakeMotorStatus(0);
            HEIGHT_RL = user::MakeMotorStatus(0);
            HEIGHT_RR = user::MakeMotorStatus(0);
        } else {
            if(HEIGHT_SW_FR) HEIGHT_FR = user::MakeMotorStatus(0);
            if(HEIGHT_SW_FL) HEIGHT_FL = user::MakeMotorStatus(0);
            if(HEIGHT_SW_RL) HEIGHT_RL = user::MakeMotorStatus(0);
            if(HEIGHT_SW_RR) HEIGHT_RR = user::MakeMotorStatus(0);

            if(HEIGHT_FR.dir == BRAKE && HEIGHT_FL.dir == BRAKE && 
            HEIGHT_RL.dir == BRAKE && HEIGHT_RR.dir == BRAKE) {
                if(state_ == State::Climb) UpPos();
                else if(state_ == State::Descent) DownPos();
                state_ = State::Stop;
             }
        }
    }

    void Lake_Height::SetPosition(Position requestPos) {
        if(pos_ < requestPos) {
            state_ = State::Climb;
            if(pos_ != Position::Bottom_Middle && pos_ != Position::Middle_Top) UpPos();
            HEIGHT_FR = user::MakeMotorStatus(-255);
            HEIGHT_FL = user::MakeMotorStatus(-255);
            HEIGHT_RL = user::MakeMotorStatus(210);
            HEIGHT_RR = user::MakeMotorStatus(210);
        } else if(pos_ > requestPos) {
            state_ = State::Descent;
            if(pos_ != Position::Bottom_Middle && pos_ != Position::Middle_Top) DownPos();
            HEIGHT_FR = user::MakeMotorStatus(255);
            HEIGHT_FL = user::MakeMotorStatus(255);
            HEIGHT_RL = user::MakeMotorStatus(-205);
            HEIGHT_RR = user::MakeMotorStatus(-205);
        }

        Update();
    }

    Lake_Height::Position Lake_Height::GetPosition() {
        return pos_;
    }

    void Lake_Height::UpPos() {
        switch(pos_) {
            case Position::Bottom :
            pos_ = Position::Bottom_Middle;
            break;
            case Position::Bottom_Middle :
            pos_ = Position::Middle;
            break;
            case Position::Middle :
            pos_ = Position::Middle_Top;
            break;
            case Position::Middle_Top :
            pos_ = Position::Top;
            break;
        }
    }

    void Lake_Height::DownPos() {
        switch(pos_) {
            case Position::Top :
            pos_ = Position::Middle_Top;
            break;
            case Position::Middle_Top :
            pos_ = Position::Middle;
            break;
            case Position::Middle :
            pos_ = Position::Bottom_Middle;
            break;
            case Position::Bottom_Middle :
            pos_ = Position::Bottom;
            break;
        }
    }

    void Lake_Height::Stop() {
        HEIGHT_FR = user::MakeMotorStatus(0);
        HEIGHT_FL = user::MakeMotorStatus(0);
        HEIGHT_RL = user::MakeMotorStatus(0);
        HEIGHT_RR = user::MakeMotorStatus(0);
    }
}
