/*
 * PID.h
 *
 * Created: 2016/07/01 17:47:45
 *  Author: yuuki
 */ 


#ifndef PID_H_
#define PID_H_

namespace PID_SPACE
{
    class PID
    {
        private:
        double diff[2];
        double integral;
        double deltaTime;
        double dataRangeLower;
        double dataRangeUpper;
        double kp,ki,kd;
        double mv;
        
        public:
        // deltaTime:1�T�C�N������( 1 / Process Frequency )
        PID(double deltaTime);
        PID(double deltaTime, double dataRangeLower, double dataRangeUpper);
        PID(double deltaTime, double dataRangeLower, double dataRangeUpper, double KP, double KI, double KD);
        
        //�p�����[�^��ݒ�
        void SetParam(double KP, double KI, double KD);
        
        //����ʂ���͂�����ʂ�擾
        double SetPV(double sensorData, double targetData);
        
        //����ʂ�擾
        double GetMV();
        
        //���͂����l�𐧌����Ď擾
        double limit(double data, double lower, double upper);

        //TODO:���x�nPID�֐�
        double SetSpeed(double sensorData,double targetData);
        
        //Yamamoto Feeling Point
        void Reset();
    };
    
    
}



#endif /* PID_H_ */