/*
* PID.cpp
*
* Created: 2016/07/01 17:47:16
*  Author: yuuki
*/

#include "PID.h"
#include <stdlib.h>

namespace PID_SPACE
{
    
    PID::PID(double deltaTime)
    {
        this->deltaTime = deltaTime;
        this->dataRangeLower = 0;
        this->dataRangeUpper = 100;
        kp = 0;
        ki = 0;
        kd = 0;
    }
    
    PID::PID(double deltaTime, double dataRangeLower, double dataRangeUpper)
    {
        this->deltaTime = deltaTime;
        this->dataRangeLower = dataRangeLower;
        this->dataRangeUpper = dataRangeUpper;
        kp = 0;
        ki = 0;
        kd = 0;
    }
    
    PID::PID(double deltaTime, double dataRangeLower, double dataRangeUpper, double KP, double KI, double KD)
    {
        this->deltaTime = deltaTime;
        this->dataRangeLower = dataRangeLower;
        this->dataRangeUpper = dataRangeUpper;
        kp = KP;
        ki = KI;
        kd = KD;
    }
    
    void PID::SetParam(double KP, double KI, double KD)
    {
        kp = KP;
        ki = KI;
        kd = KD;
    }
    
    double PID::SetPV(double sensorData, double targetData)
    {
        double p, i, d;
        
        diff[0] = diff[1];
        diff[1] = sensorData - targetData;
        integral += ((diff[1] + diff[0]) / 2.0) * deltaTime;
        
        p = kp * diff[1];
        i = ki * integral;
        d = kd * ((diff[1] - diff[0]) / deltaTime);
        mv = PID::limit(p + i + d, dataRangeLower, dataRangeUpper);
        return mv;
    }
    
    double PID::GetMV()
    {
        return mv;
    }
    
    double PID::limit(double data,double lower,double upper)
    {
        if(data < lower)        return lower;
        else if(data > upper)   return upper;
        else                    return data;
    }

    //���x�nPID�֐�
    double PID::SetSpeed(double sensorData,double targetData)
    {
        //TODO:���x�P�ʌn�̕ϊ�
    }
    
    void PID::Reset() {
        diff[0] = 0;
        diff[1] = 0;
        integral = 0;
        mv = 0;
    }
    
}

