#include "mbed.h"
#include "Process.h"

#include "../../CommonLibraries/PID/PID.h"
#include "../../CommonLibraries/PIDcontroller/PIDcontroller.h"
#include "../../Communication/RS485/ActuatorHub/ActuatorHub.h"
#include "../../Communication/Controller/Controller.h"
#include "../../Input/ExternalInt/ExternalInt.h"
#include "../../Input/Switch/Switch.h"
#include "../../Input/Potentiometer/Potentiometer.h"
#include "../../LED/LED.h"
#include "../../Safty/Safty.h"
#include "../Using.h"

#include "Lake_act.h"

using namespace SWITCH;
using namespace POTENTIOMETER;
using namespace LAKE_ACTUATOR;


static CONTROLLER::ControllerData *controller;
ACTUATORHUB::MOTOR::MotorStatus motor[MOUNTING_MOTOR_NUM];
ACTUATORHUB::SOLENOID::SolenoidStatus solenoid;

static bool lock;
static bool processChangeComp;
static int current;

static void AllActuatorReset();

#ifdef USE_SUBPROCESS
static void (*Process[USE_PROCESS_NUM])(void);
#endif

#pragma region USER-DEFINED_VARIABLES_AND_PROTOTYPE

/*Replace here with the definition code of your variables.*/
void RollerStop();
void PidTimerFunc();
void printNum(int);
uint8_t GetWithLimit(uint16_t);
void OriginalInt();
uint8_t SetStatus(int pwmVal);
uint8_t SetPWM(int pwmVal);
void BuzzerTimer_func();
void TapeLedEms_func();

//Roller
bool rollerFlag = false;
uint8_t pwmChangeIndex = ROLLER_LF_NUM;
bool pwmChangeFlag = false;
bool pwmIndexChangeFlag = false;

//Roller_Speed
Timer rollerTimer[12];
float rollerSpeed[12] = {0};
float speedTmp[12] = {0};

//Roller_PID 20-
PID rollerPID_RF = PID(2.7, 0.03, 0, 0.03);	//55
PID rollerPID_RL = PID(2.3, 0.02, 0, 0.03); //40
PID rollerPID_RB = PID(1.0, 0.01, 0, 0.03); //30
PID rollerPID_RR = PID(1.5, 0.01, 0, 0.03);	//25

Ticker pidTimer;

//Buzzer
DigitalOut buzzer(BUZZER_PIN);

int8_t rollerDispNum = 8;

Ticker myTicker;
void tickerFunc();
char *s;

Serial pc(USBTX, USBRX);

Timeout loadingTimerL;
Timeout loadingTimerC;
Timeout loadingTimerR;
void LoadingTimerL_func();
void LoadingTimerC_func();
void LoadingTimerR_func();
bool loadingFlag_L = false;
bool loadingFlag_C = false;
bool loadingFlag_R = false;

bool loadingStop_left = false;
bool loadingStop_center = false;
bool loadingStop_right = false;

ColorHubSendData colorHubSendData;

DigitalIn loadL(INT0_PIN);
DigitalIn loadC(INT1_PIN);
DigitalIn loadR(INT9_PIN);

TapeLedData tapeLED;
TapeLedData sendLedData;
TapeLED_Mode ledMode = TapeLED_Mode::Normal;

Ticker tapeLedTimer;

Lake_Height rollerHeight;

Ticker BuzzerTimer;
bool EmsFlag = false;


#pragma endregion USER-DEFINED_VARIABLES_AND_PROTOTYPE

#ifdef USE_SUBPROCESS
#if USE_PROCESS_NUM>0
static void Process0(void);
#endif
#if USE_PROCESS_NUM>1
static void Process1(void);
#endif
#if USE_PROCESS_NUM>2
static void Process2(void);
#endif
#if USE_PROCESS_NUM>3
static void Process3(void);
#endif
#if USE_PROCESS_NUM>4
static void Process4(void);
#endif
#if USE_PROCESS_NUM>5
static void Process5(void);
#endif
#if USE_PROCESS_NUM>6
static void Process6(void);
#endif
#if USE_PROCESS_NUM>7
static void Process7(void);
#endif
#if USE_PROCESS_NUM>8
static void Process8(void);
#endif
#if USE_PROCESS_NUM>9
static void Process9(void);
#endif
#endif

void SystemProcessInitialize()
{
	#pragma region USER-DEFINED_VARIABLE_INIT
	
	/*Replace here with the initialization code of your variables.*/

	for(uint8_t i=0; i<12; i++) {
		rollerTimer[i].reset();
		rollerTimer[i].start();
	}

	rollerPID_RF.setInputLimits(0, 50);
	rollerPID_RF.setOutputLimits(0, 255);
	rollerPID_RF.setSetPoint(0);
	rollerPID_RF.setProcessValue(0);
	rollerPID_RL.setInputLimits(0, 50);
	rollerPID_RL.setOutputLimits(0, 255);
	rollerPID_RL.setSetPoint(0);
	rollerPID_RL.setProcessValue(0);
	rollerPID_RB.setInputLimits(0, 50);
	rollerPID_RB.setOutputLimits(0, 255);
	rollerPID_RB.setSetPoint(0);
	rollerPID_RB.setProcessValue(0);
	rollerPID_RR.setInputLimits(0, 50);
	rollerPID_RR.setOutputLimits(0, 255);
	rollerPID_RR.setSetPoint(0);
	rollerPID_RR.setProcessValue(0);

	pidTimer.attach(PidTimerFunc, 0.03);

	// myTicker.attach(tickerFunc, 1);

	pc.baud(921600);

	colorHubSendData.data0 = 0x77;
	colorHubSendData.data1 = 0x17;
	colorHubSendData.data2 = 0x00;

	loadL.mode(PullUp);
	loadC.mode(PullUp);
	loadR.mode(PullUp);

	tapeLED.code = (uint32_t)TapeLED_Color::Black;

	#pragma endregion USER-DEFINED_VARIABLE_INIT

	AllActuatorReset();

	lock = true;
	processChangeComp = true;
	current = DEFAULT_PROCESS;

	#ifdef USE_SUBPROCESS
	#if USE_PROCESS_NUM>0
	Process[0] = Process0;
	#endif
	#if USE_PROCESS_NUM>1
	Process[1] = Process1;
	#endif
	#if USE_PROCESS_NUM>2
	Process[2] = Process2;
	#endif
	#if USE_PROCESS_NUM>3
	Process[3] = Process3;
	#endif
	#if USE_PROCESS_NUM>4
	Process[4] = Process4;
	#endif
	#if USE_PROCESS_NUM>5
	Process[5] = Process5;
	#endif
	#if USE_PROCESS_NUM>6
	Process[6] = Process6;
	#endif
	#if USE_PROCESS_NUM>7
	Process[7] = Process7;
	#endif
	#if USE_PROCESS_NUM>8
	Process[8] = Process8;
	#endif
	#if USE_PROCESS_NUM>9
	Process[9] = Process9;
	#endif
	#endif
}

static void SystemProcessUpdate()
{
	#ifdef USE_SUBPROCESS
	if(controller->Button.HOME) lock = false;
	
	if(controller->Button.START && processChangeComp)
	{
		current++;
		if (USE_PROCESS_NUM < current) current = USE_PROCESS_NUM;
		processChangeComp = false;
	}
	else if(controller->Button.SELECT && processChangeComp)
	{
		current--;
		if (current < 0) current = 0;
		processChangeComp = false;
	}
	else if(!controller->Button.SELECT && !controller->Button.START) processChangeComp = true;
	#endif
	
	#ifdef USE_MOTOR
	ACTUATORHUB::MOTOR::Motor::Update(motor);
	#endif
	
	#ifdef USE_SOLENOID
	ACTUATORHUB::SOLENOID::Solenoid::Update(solenoid);
	#endif

	#ifdef USE_RS485
	ACTUATORHUB::ActuatorHub::Update();
	#endif
	
}

void SystemProcess()
{
	SystemProcessInitialize();

	while(1)
	{
		#ifdef USE_MU
		controller = CONTROLLER::Controller::GetData();
		#endif

		#ifdef USE_ERRORCHECK
		if(SAFTY::ErrorCheck::Check() & SAFTY::Error::ControllerLost)
		{
			CONTROLLER::Controller::DataReset();
			AllActuatorReset();
			lock = true;
			tapeLED.code = (uint32_t)TapeLED_Color::White;
		}
		else
		#endif
		{
			#ifdef USE_SUBPROCESS
			if(!lock)
			{
				Process[current]();
				if(!BluetoothSendBuffer.InAnyData()) {
					printNum(current);
					BluetoothSendBuffer.PutData('\n');
				}
			}
			else
			#endif
			{
				//ロック時の処理
				if(!BluetoothSendBuffer.InAnyData()) BluetoothSendBuffer.PutData("L\n", 2);
				RollerStop();
				tapeLED.code = (uint32_t)TapeLED_Color::Black;
			}
		}
		// if(SWITCH::LimitSw::IsPressed(1)) LED_DEBUG0 = LED_ON;
		// else LED_DEBUG0 = LED_OFF;

		// printf("%s %s %s %s %s %s %s %s %s %s %s %s\n", SWITCH::LimitSw::IsPressed(0) ? "0" : " ", 
		// 												SWITCH::LimitSw::IsPressed(1) ? "1" : " ",
		// 												SWITCH::LimitSw::IsPressed(2) ? "2" : " ",
		// 												SWITCH::LimitSw::IsPressed(3) ? "3" : " ",
		// 												SWITCH::LimitSw::IsPressed(4) ? "4" : " ",
		// 												SWITCH::LimitSw::IsPressed(5) ? "5" : " ",
		// 												SWITCH::LimitSw::IsPressed(6) ? "6" : " ",
		// 												SWITCH::LimitSw::IsPressed(7) ? "7" : " ",
		// 												SWITCH::LimitSw::IsPressed(8) ? "8" : " ",
		// 												SWITCH::LimitSw::IsPressed(9) ? "9" : " ",
		// 												SWITCH::LimitSw::IsPressed(10) ? "10" : " ",
		// 												SWITCH::LimitSw::IsPressed(11) ? "11" : " ");

		// printf("%f %f %f %f\n", adc[0].read(), adc[1].read(), adc[2].read(), adc[3].read());

		// if(intTest == false && pIntTest == true) LED_DEBUG0 = !LED_DEBUG0;
		// pIntTest = intTest;

		// if(intTest) LED_DEBUG0 = LED_ON;
		// else LED_DEBUG0 = LED_OFF;

		// if(LimitSw::IsPressed(0)) ss[0] = 1;
		// else ss[0] = 0;

		// if(controller->Button.A) buzzer = 1;
		// else buzzer = 0;

		for(uint8_t i=0; i<12; i++) {
			rollerSpeed[i] = 1.0/speedTmp[i];
			if(rollerTimer[i].read() > 1) rollerSpeed[i] = 0;
		}

		// if(LimitSw::IsPressed(12)) LED_DEBUG0 = LED_ON;
		// else LED_DEBUG0 = LED_OFF;

		// printf("%.2f,%d\r\n", rollerSpeed[1], ROLLER_LL.pwm);

		OriginalInt();


		if((EMS0 || EMS1) && !EmsFlag) {
			//EMS PUSH
			buzzer = 1;
			BuzzerTimer.attach(BuzzerTimer_func, 1.2);
			EmsFlag = true;
			RollerStop();
			ledMode = TapeLED_Mode::EMS;
			tapeLedTimer.attach(TapeLedEms_func, 1.2);
		}

		if(!EMS0 && !EMS1) {
			buzzer = 0;
			BuzzerTimer.detach();
			EmsFlag = false;
			if(ledMode == TapeLED_Mode::EMS) ledMode = TapeLED_Mode::Normal;
			tapeLedTimer.detach();
		}

		switch(ledMode)
		{
			case TapeLED_Mode::EMS :
				break;

			case TapeLED_Mode::Normal :
				sendLedData.code = tapeLED.code;

			default:
				break;
		}

		SystemProcessUpdate();
	}
}

#pragma region PROCESS
#ifdef USE_SUBPROCESS
#if USE_PROCESS_NUM>0
static void Process0()
{
	RollerStop();
	// printf("now:%d\n", (int)rollerHeight.GetPosition());
	// rollerHeight.SetPosition(Lake_Height::Position::Middle);
	// rollerHeight.Update();
	tapeLED.code = (uint32_t)TapeLED_Color::Red;
}
#endif

#if USE_PROCESS_NUM>1
static void Process1()
{
	tapeLED.code = (uint32_t)TapeLED_Color::Green;
	if(controller->Button.L && controller->Button.R && !rollerFlag) {
		if(controller->Button.UP) {
			RollerStop();
			rollerFlag = true;
		} else if(controller->Button.LEFT) {
			motor[ROLLER_LF_NUM].dir = motor[ROLLER_LF_NUM].dir == FREE ? BACK : FREE;
			motor[ROLLER_LL_NUM].dir = motor[ROLLER_LL_NUM].dir == FREE ? BACK : FREE;
			motor[ROLLER_LB_NUM].dir = motor[ROLLER_LB_NUM].dir == FREE ? BACK : FREE;
			motor[ROLLER_LR_NUM].dir = motor[ROLLER_LR_NUM].dir == FREE ? BACK : FREE;
			rollerFlag = true;
		} else if(controller->Button.DOWN) {
			motor[ROLLER_CF_NUM].dir = motor[ROLLER_CF_NUM].dir == FREE ? BACK : FREE;
			motor[ROLLER_CL_NUM].dir = motor[ROLLER_CL_NUM].dir == FREE ? BACK : FREE;
			motor[ROLLER_CB_NUM].dir = motor[ROLLER_CB_NUM].dir == FREE ? BACK : FREE;
			motor[ROLLER_CR_NUM].dir = motor[ROLLER_CR_NUM].dir == FREE ? BACK : FREE;
			rollerFlag = true;
		} else if(controller->Button.RIGHT) {
			motor[ROLLER_RF_NUM].dir = motor[ROLLER_RF_NUM].dir == FREE ? BACK : FREE;
			motor[ROLLER_RL_NUM].dir = motor[ROLLER_RL_NUM].dir == FREE ? BACK : FREE;
			motor[ROLLER_RB_NUM].dir = motor[ROLLER_RB_NUM].dir == FREE ? BACK : FREE;
			motor[ROLLER_RR_NUM].dir = motor[ROLLER_RR_NUM].dir == FREE ? BACK : FREE;
			rollerFlag = true;
		}
	}
	if(!controller->Button.L && !controller->Button.R) rollerFlag = false;

	//pwm Change
	uint8_t pwmOnceChange = 1;
	if(controller->Button.A) pwmOnceChange = 10;

	if(controller->Button.ZR && !pwmChangeFlag && motor[pwmChangeIndex].pwm <= 255-pwmOnceChange) {
		motor[pwmChangeIndex].pwm += pwmOnceChange;
		pwmChangeFlag = true;
	} else if(controller->Button.ZL && !pwmChangeFlag && motor[pwmChangeIndex].pwm >= pwmOnceChange) {
		motor[pwmChangeIndex].pwm -= pwmOnceChange;
		pwmChangeFlag = true;
	}
	if(!controller->Button.ZR && !controller->Button.ZL) pwmChangeFlag = false;

	if(controller->Button.Y) motor[pwmChangeIndex].pwm = 0xff;

	if(controller->Button.B && !pwmIndexChangeFlag) {
		pwmChangeIndex++;
		pwmIndexChangeFlag = true;
	} else if(controller->Button.X && !pwmIndexChangeFlag) {
		pwmChangeIndex--;
		pwmIndexChangeFlag = true;
	}

	if(pwmChangeIndex < 4) pwmChangeIndex = 4;
	else if(pwmChangeIndex == 10) pwmChangeIndex = 13;
	else if(pwmChangeIndex == 12) pwmChangeIndex = 9;
	else if(pwmChangeIndex > 18) pwmChangeIndex = 18;

	if(!controller->Button.X && !controller->Button.B) pwmIndexChangeFlag = false;

	//Display
	switch(pwmChangeIndex) {
		case ROLLER_LF_NUM:
			s = "LEFT-FRONT";
			rollerDispNum = 0;
			break;
		case ROLLER_LL_NUM:
			s = "LEFT-LEFT";
			rollerDispNum = 1;
			break;
		case ROLLER_LB_NUM:
			s = "LEFT-BACK";
			rollerDispNum = 2;
			break;
		case ROLLER_LR_NUM:
			s = "LEFT-RIGHT";
			rollerDispNum = 3;
			break;
		case ROLLER_CF_NUM:
			s = "CENTER-FRONT";
			rollerDispNum = 4;
			break;
		case ROLLER_CL_NUM:
			s = "CENTER-LEFT";
			rollerDispNum = 5;
			break;
		case ROLLER_CB_NUM:
			s = "CENTER-BACK";
			rollerDispNum = 6;
			break;
		case ROLLER_CR_NUM:
			s = "CENTER-RIGHT";
			rollerDispNum = 7;
			break;
		case ROLLER_RF_NUM:
			s = "RIGHT-FRONT";
			rollerDispNum = 8;
			break;
		case ROLLER_RL_NUM:
			s = "RIGHT-LEFT";
			rollerDispNum = 9;
			break;
		case ROLLER_RB_NUM:
			s = "RIGHT-BACK";
			rollerDispNum = 10;
			break;
		case ROLLER_RR_NUM:
			s = "RIGHT-RIGHT";
			rollerDispNum = 11;
			break;
		default:
			s = "???";
			rollerDispNum = 0;
			break;
	}

	LOADING_MOTOR_LEFT.dir = FREE;
	LOADING_MOTOR_RIGHT.dir = FREE;

	static uint16_t dispCnt = 0;
	if(dispCnt == 0x3ff) {
		pc.printf("%s : %d, %.1f\n", s, motor[pwmChangeIndex].pwm, rollerSpeed[rollerDispNum]);
		dispCnt = 0;
	} else dispCnt++;
}
#endif

#if USE_PROCESS_NUM>2
static void Process2()
{
	tapeLED.code = (uint32_t)TapeLED_Color::Blue;
	if(controller->Button.ZL && !loadingFlag_L)	{
		LOADING_AIR_LEFT = SOLENOID_ON;
		loadingFlag_L = true;
		loadingTimerL.attach(LoadingTimerL_func, 2);
		sendLedData.code = (uint32_t)TapeLED_Color::White;
	}

	if(controller->Button.L && !loadingFlag_C)	{
		LOADING_AIR_CENTER = SOLENOID_ON;
		loadingFlag_C = true;
		loadingTimerC.attach(LoadingTimerC_func, 2);
		sendLedData.code = (uint32_t)TapeLED_Color::White;
	}

	if(controller->Button.ZR && !loadingFlag_R) {
		LOADING_AIR_RIGHT = SOLENOID_ON;
		loadingFlag_R = true;
		loadingTimerR.attach(LoadingTimerR_func, 2);
		sendLedData.code = (uint32_t)TapeLED_Color::White;
	}

	if(!controller->Button.ZL) loadingFlag_L = false;
	if(!controller->Button.L) loadingFlag_C = false;
	if(!controller->Button.ZR) loadingFlag_R = false;


	LOADING_MOTOR_LEFT.pwm = 0xff;
	LOADING_MOTOR_CENTER.pwm = 0xff;
	LOADING_MOTOR_RIGHT.pwm = 0xff;

	if(!loadingStop_left) {
		if(controller->Button.UP)			LOADING_MOTOR_LEFT.dir = FOR;
		else if(controller->Button.DOWN)	LOADING_MOTOR_LEFT.dir = BACK;
		else								LOADING_MOTOR_LEFT.dir = BRAKE;
	} else LOADING_MOTOR_LEFT.dir = BRAKE;

	if(!controller->Button.UP && !controller->Button.DOWN) loadingStop_left = false;

	if(!loadingStop_right) {
		if(controller->Button.X)		LOADING_MOTOR_RIGHT.dir = FOR;
		else if(controller->Button.B)	LOADING_MOTOR_RIGHT.dir = BACK;
		else							LOADING_MOTOR_RIGHT.dir = BRAKE;
	} else LOADING_MOTOR_RIGHT.dir = BRAKE;

	if(!controller->Button.X && !controller->Button.B) loadingStop_right = false;

	if(!loadingStop_center) {
		if(controller->Button.LEFT)			LOADING_MOTOR_CENTER.dir = FOR;
		else if(controller->Button.RIGHT)	LOADING_MOTOR_CENTER.dir = BACK;
		else								LOADING_MOTOR_CENTER.dir = BRAKE;
	} else LOADING_MOTOR_CENTER.dir = BRAKE;

	if(!controller->Button.LEFT && !controller->Button.RIGHT) loadingStop_center = false;
}
#endif

#if USE_PROCESS_NUM>3
static void Process3()
{
	tapeLED.code = (uint32_t)TapeLED_Color::White;
	rollerPID_RF.setSetPoint(43.0);
	rollerPID_RL.setSetPoint(21);
	rollerPID_RB.setSetPoint(32);
	rollerPID_RR.setSetPoint(50);

	static bool rollerStartFlag = false;

	if(controller->Button.L && controller->Button.R && !rollerStartFlag) {
		motor[ROLLER_RF_NUM].dir = motor[ROLLER_RF_NUM].dir == FREE ? BACK : FREE;
		motor[ROLLER_RL_NUM].dir = motor[ROLLER_RL_NUM].dir == FREE ? BACK : FREE;
		motor[ROLLER_RB_NUM].dir = motor[ROLLER_RB_NUM].dir == FREE ? BACK : FREE;
		motor[ROLLER_RR_NUM].dir = motor[ROLLER_RR_NUM].dir == FREE ? BACK : FREE;
		rollerStartFlag = true;
	}

	if(!controller->Button.L && !controller->Button.R) rollerStartFlag = false;

	ROLLER_RF.pwm = GetWithLimit(rollerPID_RF.compute() + 55);
	ROLLER_RL.pwm = GetWithLimit(rollerPID_RL.compute() + 40);
	ROLLER_RB.pwm = GetWithLimit(rollerPID_RB.compute() + 30);
	ROLLER_RR.pwm = GetWithLimit(rollerPID_RR.compute() + 25);

	// RollerStop();
	// if(rollerSpeed[0] < 5) ROLLER_CB.pwm = 0xff;

	LOADING_MOTOR_LEFT.dir = FREE;
	LOADING_MOTOR_RIGHT.dir = FREE;

	static uint16_t printCnt = 0;
	if(printCnt >= 0xff) {
		// pc.printf("%.1f,%.1f,%.1f,%.1f\r", rollerSpeed[0], rollerSpeed[1], rollerSpeed[2], rollerSpeed[3]);
		printCnt = 0;
	} else printCnt++;

	rollerHeight.Stop();
}
#endif

#if USE_PROCESS_NUM>4
static void Process4()
{
	RollerStop();
	static Lake_Height::Position pos;

	if(controller->Button.UP) pos = Lake_Height::Position::Top;
	if(controller->Button.DOWN) pos = Lake_Height::Position::Bottom;
	if(controller->Button.RIGHT) pos = Lake_Height::Position::Middle;

	rollerHeight.SetPosition(Lake_Height::Position::Middle);
	rollerHeight.Update();

	if(!controller->Button.A) rollerHeight.Stop();

	colorHubSendData.actuatorReset = true;
}
#endif

#if USE_PROCESS_NUM>5
static void Process5()
{
		tapeLED.code = (uint32_t)TapeLED_Color::Orange;
	colorHubSendData.Vector.X = controller->AnalogL.X;
	colorHubSendData.Vector.Y = controller->AnalogL.Y;
	colorHubSendData.rotate = controller->AnalogR.X;
	colorHubSendData.actuatorReset = false;
	colorHubSendData.mode = (uint8_t)TraceMode::Manual;
	rollerHeight.Stop();
}
#endif

#if USE_PROCESS_NUM>6
static void Process6()
{
	tapeLED.code = (uint32_t)TapeLED_Color::Yellow;
	AllActuatorReset();
}
#endif

#if USE_PROCESS_NUM>7
static void Process7()
{
	tapeLED.code = (uint32_t)TapeLED_Color::Purple;
	if(controller->Button.UP) {
		if(controller->Button.L) HEIGHT_FL = user::MakeMotorStatus(-255);
		else HEIGHT_FL = user::MakeMotorStatus(0);
		if(controller->Button.ZL) HEIGHT_RL = user::MakeMotorStatus(-255);
		else HEIGHT_RL = user::MakeMotorStatus(0);
		if(controller->Button.R) HEIGHT_FR = user::MakeMotorStatus(210);
		else HEIGHT_FR = user::MakeMotorStatus(0);
		if(controller->Button.ZR) HEIGHT_RR = user::MakeMotorStatus(210);
		else HEIGHT_RR = user::MakeMotorStatus(0);
	} else if(controller->Button.DOWN) {
		if(controller->Button.L) HEIGHT_FL = user::MakeMotorStatus(255);
		else HEIGHT_FL = user::MakeMotorStatus(0);
		if(controller->Button.ZL) HEIGHT_RL = user::MakeMotorStatus(255);
		else HEIGHT_RL = user::MakeMotorStatus(0);
		if(controller->Button.R) HEIGHT_FR = user::MakeMotorStatus(-205);
		else HEIGHT_FR = user::MakeMotorStatus(0);
		if(controller->Button.ZR) HEIGHT_RR = user::MakeMotorStatus(-205);
		else HEIGHT_RR = user::MakeMotorStatus(0);
	} else {
		HEIGHT_FR = user::MakeMotorStatus(0);
		HEIGHT_FL = user::MakeMotorStatus(0);
		HEIGHT_RL = user::MakeMotorStatus(0);
		HEIGHT_RR = user::MakeMotorStatus(0);
	}
}
#endif

#if USE_PROCESS_NUM>8
static void Process8()
{
	tapeLED.code = (uint32_t)TapeLED_Color::Cyan;
	AllActuatorReset();
}
#endif

#if USE_PROCESS_NUM>9
static void Process9()
{
	tapeLED.code = (uint32_t)TapeLED_Color::Magenta;
	// if(controller->Button.L) colorHubSendData.zoneRed = false;
	// if(controller->Button.R) colorHubSendData.zoneRed = true;

	if(controller->Button.A) colorHubSendData.actuatorReset = false;
	else colorHubSendData.actuatorReset = true;

	// static TraceMode m = TraceMode::Trace_to_Table;

	// switch(m) {
	// 	case TraceMode::Trace_to_Table :
	// 		colorHubSendData.Vector.X = colorHubSendData.zoneRed ? 0 : 14;
	// 		colorHubSendData.Vector.Y = 0;
	// 		if(LS_FL && LS_FR) {
	// 			colorHubSendData.Vector.X = 7;
	// 			colorHubSendData.Vector.Y = 7;
	// 			if(controller->Button.B) m = TraceMode::Trace_to_Fance;
	// 		}
	// 		break;

	// 	case TraceMode::Trace_to_Fance :
	// 		colorHubSendData.Vector.Y = 14;
	// 		if(LS_RL && LS_RR) {
	// 			colorHubSendData.Vector.Y = 7;
	// 			if(controller->Button.B) m = TraceMode::Trace_to_Table;
	// 		}
	// 		break;
	// }

	// colorHubSendData.mode = (uint8_t)m;

	colorHubSendData.mode = (uint8_t)TraceMode::TraceTest;
	colorHubSendData.Vector.Y = controller->AnalogL.Y;
}
#endif
#endif
#pragma endregion PROCESS

static void AllActuatorReset()
{

	#ifdef USE_SOLENOID
	solenoid.all = ALL_SOLENOID_OFF;
	#endif

	#ifdef USE_MOTOR
	for (uint8_t i = 0; i < MOUNTING_MOTOR_NUM; i++)
	{
		motor[i].dir = FREE;
		motor[i].pwm = 0x00;
	}
	#endif

	colorHubSendData.actuatorReset = true;
}

#pragma region USER-DEFINED-FUNCTIONS
void RollerStop() {
	motor[ROLLER_LF_NUM].dir = FREE;
	motor[ROLLER_LL_NUM].dir = FREE;
	motor[ROLLER_LB_NUM].dir = FREE;
	motor[ROLLER_LR_NUM].dir = FREE;
	motor[ROLLER_RF_NUM].dir = FREE;
	motor[ROLLER_RL_NUM].dir = FREE;
	motor[ROLLER_RB_NUM].dir = FREE;
	motor[ROLLER_RR_NUM].dir = FREE;
	motor[ROLLER_CF_NUM].dir = FREE;
	motor[ROLLER_CL_NUM].dir = FREE;
	motor[ROLLER_CB_NUM].dir = FREE;
	motor[ROLLER_CR_NUM].dir = FREE;
}

void PidTimerFunc() {
	rollerPID_RF.setProcessValue(rollerSpeed[8]);
	rollerPID_RL.setProcessValue(rollerSpeed[9]);
	rollerPID_RB.setProcessValue(rollerSpeed[10]);
	rollerPID_RR.setProcessValue(rollerSpeed[11]);
}

void printNum(int num) {
	BluetoothSendBuffer.PutData(num < 0 ? '-' : ' ');
	if(num < 0) {
		num = -num;
		BluetoothSendBuffer.PutData(num/10000, true);
		BluetoothSendBuffer.PutData(num/1000%10, true);
		BluetoothSendBuffer.PutData(num/100%10, true);
		BluetoothSendBuffer.PutData(num/10%10, true);
		BluetoothSendBuffer.PutData(num%10, true);
	} else {
		BluetoothSendBuffer.PutData(num/10000, true);
		BluetoothSendBuffer.PutData(num/1000%10, true);
 		BluetoothSendBuffer.PutData(num/100%10, true);
		BluetoothSendBuffer.PutData(num/10%10, true);
		BluetoothSendBuffer.PutData(num%10, true);
	}
}

uint8_t GetWithLimit(uint16_t num) {
	return num > 0xff ? 0xff : num;
}

void tickerFunc() {
		printf("%s : %d %f\n", s, motor[pwmChangeIndex].pwm, rollerSpeed[rollerDispNum]);
}

void LoadingTimerL_func() {
	LOADING_AIR_LEFT = SOLENOID_OFF;
	sendLedData.code = tapeLED.code;
}

void LoadingTimerC_func() {
	LOADING_AIR_CENTER = SOLENOID_OFF;
	sendLedData.code = tapeLED.code;
}

void LoadingTimerR_func() {
	LOADING_AIR_RIGHT = SOLENOID_OFF;
	sendLedData.code = tapeLED.code;
}

void OriginalInt() {
	static bool stateL = false;
	static bool stateC = false;
	static bool stateR = false;
	static bool pStateL = false;
	static bool pStateC = false;
	static bool pStateR = false;

	static uint8_t loadC_cnt = 0;

	stateL = loadL;
	stateC = loadC;
	stateR = loadR;

	if(stateL && !pStateL)
	{
		//int0 rise
		loadingStop_left = true;
	}

	if(!stateC && pStateC)
	{
		//int1 fall
		loadC_cnt++;
		if(loadC_cnt == 6) {
			loadingStop_center = true;
			loadC_cnt = 0;
		}
	}

	if(stateR && !pStateR)
	{
		//int9 rise
		loadingStop_right = true;
	}

	pStateL = stateL;
	pStateC = stateC;
	pStateR = stateR;
}

uint8_t SetStatus(int pwmVal){
	if(pwmVal < 0) return BACK;
	else if(pwmVal > 0) return FOR;
	else return BRAKE;
}

uint8_t SetPWM(int pwmVal){
	if(pwmVal == 0 || pwmVal >  255 || pwmVal < -255) return 255;
	else return abs(pwmVal);
}

void BuzzerTimer_func() {
	buzzer = !buzzer;
}

void TapeLedEms_func() {
	sendLedData.code = sendLedData.code == (uint32_t)TapeLED_Color::Red ? (uint32_t)TapeLED_Color::Black : (uint32_t)TapeLED_Color::Red;
}

#pragma endregion
