/**
 *  @file       main.cpp
 *  @brief      Measuring plethysmogram and pulse rate with BH1792GLC
 *  @date       2018.02.06
 *  @version    1.0.1
 */
#include "mbed.h"
#include "USBSerial.h"
#include "PulseRate.h"

#define PACKET_HEADER (0xAA)
#define PULSE_RATE_ID (0xBB)
#define BYTE_MASK (0xFF)

USBSerial serial;
#ifdef _OP_MODE_INT_AD
PulseRate pr(p20, LED1, p26);           /* Sensor, LED, Beep */
#elif defined _OP_MODE_BH1792GLC
PulseRate pr(p28, p27, p20, LED1, p26); /* SDA, SCL, INT, LED, Beep */
#endif

/** Send data packet
 *  @param      second_val  Byte data at packet address 0x01
 *  @param      data_val    Short data at packet address 0x02, 0x03
 */
bool send_packet(int second_val, int data_val)
{
    if(serial.writeable()) {
        serial.putc(PACKET_HEADER);
        serial.putc(second_val & BYTE_MASK);
        serial.putc((data_val >> 8 ) & BYTE_MASK);
        serial.putc(data_val & BYTE_MASK);
        return true;
    } else {
        return false;
    }
}

/** Main function
 */
int main()
{
    uint32_t num;
    int32_t wave;
    uint32_t rate;

    pr.start_sampling();    /* start procedure */

    while(1) {
        /* Pulse waveform */
        if(pr.get_wave(num, wave)) {
            send_packet(num, wave);
        }
        /* Pulse rate */
        if(pr.get_pr_val(rate)) {
            send_packet(PULSE_RATE_ID, rate);
        }
    }
}
