/**
 *  @file       Bh1792glcCtrl.h
 *  @brief      Header file for Bh1792glcCtrl.cpp
 *  @date       2018.02.06
 *  @version    1.0.1
 */
#ifndef _INC_Bh1792glcCtrl
#define _INC_Bh1792glcCtrl

#include "mbed.h"
#include "Bh1792glcReg.h"

/** Constants
 */
#define I2C_FREQENCY            (400000)    /* I2C SCL freqency */

#define DEFAULT_PARAM_SIZE      (6)         /* Bytes through MEAS_CONTROL 1 - 5 */
#define DEFAULT_LED_CURRENT1    (1)         /* LED 1 current intensity */
#define DEFAULT_LED_CURRENT2    (0)         /* LED 2 current intensity */
#define DEFAULT_MEAS_CTRL4_LSB  (0xFC)      /* Threshold IR interrupt (LSB) */
#define DEFAULT_MEAS_CTRL4_MSB  (0xFF)      /* Threshold IR interrupt (MSB) */

#define INT_CHECK_INTERVAL_US   (10)        /* Int terminal check interval [us] */
#define INT_CHECK_COUNT_LIMIT   (100)       /* Int terminal check count limit */

/** Calculate pulse waveform and pulse rate
 */
class Bh1792glcCtrl
{

public:
    Bh1792glcCtrl(PinName bh_sda, PinName bh_scl, PinName bh_int);
    int get_val(int32_t &val);

private:
    I2C         _i2c;
    DigitalIn   _bh_int;            /* Interrupt from BH1792GLC */

    int _sad;

    int init();
    int send_default_params();
    int start_measure();

};
#endif    /* INC_Bh1792glcCtrl */
