//////////////////////////////////////////////////////////////////////////////
// Model: Network.qm
// File:  ./bsp.cpp
//
// This file has been generated automatically by QP Modeler (QM).
// DO NOT EDIT THIS FILE MANUALLY.
//
// Please visit www.state-machine.com/qm for more information.
//////////////////////////////////////////////////////////////////////////////
#include "qp_port.h"
#include "network.h"
#include "bsp.h"
#include "LPC17xx.h"

Q_DEFINE_THIS_FILE

// Local-scope objects -------------------------------------------------------
enum ISR_Priorities {      // ISR priorities starting from the highest urgency
    GPIOPORTA_PRIO,
    SYSTICK_PRIO,
    // ...
};

#define LED_PORT      LPC_GPIO1
#define LED1_BIT     (1U << 18)
#define LED2_BIT     (1U << 20)
#define LED3_BIT     (1U << 21)
#define LED4_BIT     (1U << 23)

#ifdef Q_SPY
    #include "mbed.h"             // mbed is used only for the built-in serial

    QSTimeCtr l_tickTime;
    QSTimeCtr l_tickPeriod;

    #define QSPY_BAUD_RATE          115200

    enum AppRecords {                    // application-specific trace records
        PELICAN_STAT = QS_USER,
        IO_STAT
    };

    Serial l_qspy(USBTX, USBRX);
#endif

//............................................................................
extern "C" void SysTick_Handler(void) {
    QK_ISR_ENTRY();                // inform the QK kernel of entering the ISR

#ifdef Q_SPY
    uint32_t volatile dummy = SysTick->CTRL; // clear the COUNTFLAG in SysTick
    l_tickTime += l_tickPeriod;              // account for the clock rollover
#endif

    QF::tick();                               // process all armed time events

    QK_ISR_EXIT();                  // inform the QK kernel of exiting the ISR
}

//............................................................................
static N4S2 l_N4S2;


DigitalIn  N4S2 :: geomSenses[N_FACES] = {(p17), (p18), (p19), (p20)};
DigitalOut N4S2 :: geomTxs[S_FACES] = {(p21), (p22)};

SerialHalfDuplex  N4S2 :: sPort1(p9,p10);//common n bus
SerialHalfDuplex  N4S2 :: sPort2(p13,p14);//common n bus
SerialHalfDuplex  N4S2 :: sPorts[S_FACES] = {sPort1,sPort2}; //seg ports
SerialHalfDuplex  N4S2 :: nPort(p28,p27);//common n bus

DigitalOut N4S2 :: sPort1ETx(p11);
DigitalOut N4S2 :: sPort2ETx(p12);
DigitalOut N4S2 :: nPortETx(p29);
DigitalOut N4S2 :: sPortETxs[S_FACES] = {sPort1ETx, sPort2ETx};

DigitalOut N4S2 :: leds[] = {(LED1), (LED2), (LED3), (LED4)};


//............................................................................
void BSP_init(void) {
    SystemInit();                            // initialize the clocking system

                                                     // set LED port to output
    LED_PORT->FIODIR |= (LED1_BIT | LED2_BIT | LED3_BIT | LED4_BIT);

                                                             // clear the LEDs
    LED_PORT->FIOCLR  = (LED1_BIT | LED2_BIT | LED3_BIT | LED4_BIT);

    if (QS_INIT((void *)0) == 0) {       // initialize the QS software tracing
        Q_ERROR();
    }
}
//............................................................................
void BSP_signalCars(BSP_CarsSignal sig) {
    /*
    switch (sig) {
        case CARS_RED:
            LED_PORT->FIOSET = LED1_BIT;                   // turn the LED1 on
            LED_PORT->FIOCLR = LED2_BIT | LED3_BIT;     // turn the LED2&3 off
            break;
        case CARS_YELLOW:
            LED_PORT->FIOSET = LED2_BIT;                   // turn the LED2 on
            LED_PORT->FIOCLR = LED1_BIT | LED3_BIT;     // turn the LED1&3 off
            break;
        case CARS_GREEN:
            LED_PORT->FIOSET = LED3_BIT;                   // turn the LED3 on
            LED_PORT->FIOCLR = LED1_BIT | LED2_BIT;     // turn the LED1&2 off
            break;
        case CARS_BLANK:
            LED_PORT->FIOCLR =  LED1_BIT | LED2_BIT | LED3_BIT; //turn all off
            break;
    }*/
}
//............................................................................
void BSP_signalPeds(BSP_PedsSignal sig) {
    /*
    switch (sig) {
        case PEDS_DONT_WALK:
            LED_PORT->FIOSET = LED4_BIT;                   // turn the LED4 on
            break;
        case PEDS_WALK:
            LED_PORT->FIOCLR = LED4_BIT;                  // turn the LED4 off
            break;
        case PEDS_BLANK:
            LED_PORT->FIOCLR = LED4_BIT;                  // turn the LED4 off
            break;
    }*/
}
//............................................................................
void BSP_showState(char const *state) {
    QS_BEGIN(PELICAN_STAT, AO_Pelican)          // application-specific record
        QS_STR(state);                                         // state string
    QS_END()
}

//............................................................................
void BSP_signalSense(BSP_SenseSignal sig) {
    switch (sig) {
        case SENSE_1_CON:
            LED_PORT->FIOSET = LED1_BIT;                   // turn the LED4 on
            break;
        case SENSE_1_DIS:
            LED_PORT->FIOCLR = LED1_BIT;                  // turn the LED4 off
            break;
    }
}

//............................................................................
void BSP_chk_io() {
    QS_BEGIN(IO_STAT, AO_Poll)          // application-specific record
        QS_STR("chk_io_called");
        static int prev[4] = {0,0,0,0};
        for(int i=0;i<l_N4S2.N_FACES;i++){
            int newVal = l_N4S2.geomSenses[i];
            if(newVal == 0 && prev[i] !=0){
                QF::publish(&sense1_N1_Down_Evt);
            }else if(newVal != 0 && prev[i] ==0){
                QF::publish(&sense1_N1_Up_Evt);
            }
            prev[i] = newVal;
        }
    QS_END()
}

//............................................................................
void QF::onStartup(void) {
                 // set up the SysTick timer to fire at BSP_TICKS_PER_SEC rate
    SysTick_Config(SystemCoreClock / BSP_TICKS_PER_SEC);

                          // set priorities of all interrupts in the system...
    NVIC_SetPriority(SysTick_IRQn, SYSTICK_PRIO);
    NVIC_SetPriority(EINT0_IRQn,   GPIOPORTA_PRIO);

    NVIC_EnableIRQ(EINT0_IRQn);
}
//............................................................................
void QF::onCleanup(void) {
}
//............................................................................
void QK::onIdle(void) {
#ifdef Q_SPY
    if (l_qspy.writeable()) {
        QF_INT_LOCK(dummy);
        uint16_t b = QS::getByte();
        QF_INT_UNLOCK(dummy);
        if (b != QS_EOD) {
            l_qspy.putc((uint8_t)b);
        }
    }
#else
    // put the CPU and peripherals to the low-power mode
    // you might need to customize the clock management for your application,
    // see the datasheet for your particular Cortex-M3 MCU.
    __WFI();
#endif
}

//............................................................................
void Q_onAssert(char const Q_ROM * const Q_ROM_VAR file, int line) {
    (void)file;                                      // avoid compiler warning
    (void)line;                                      // avoid compiler warning
    QS_BEGIN_(QS_ASSERT, 0, 0)
        QS_TIME_();                                              // time stamp
        QS_U16_((uint16_t)line);                            // the line number
        QS_STR_(file);                                        // the file name
    QS_END_()
    QS::onFlush();

    QF_INT_LOCK(dummy);          // make sure that all interrupts are disabled
                                                          // light up all LEDs
    LED_PORT->FIOSET = (LED1_BIT | LED2_BIT | LED3_BIT | LED4_BIT);

    for (;;) {          // NOTE: replace the loop with reset for final version
    }
}

//----------------------------------------------------------------------------
#ifdef Q_SPY
//............................................................................
uint8_t QS::onStartup(void const *arg) {
    static uint8_t qsBuf[6*256];                     // buffer for Quantum Spy
    initBuf(qsBuf, sizeof(qsBuf));

    l_qspy.baud(QSPY_BAUD_RATE);

    l_tickPeriod = SystemCoreClock / BSP_TICKS_PER_SEC;
    l_tickTime   = l_tickPeriod;             // to start the timestamp at zero

                                                    // setup the QS filters...
    QS_FILTER_ON(QS_ALL_RECORDS);

//    QS_FILTER_OFF(QS_QEP_STATE_EMPTY);
//    QS_FILTER_OFF(QS_QEP_STATE_ENTRY);
//    QS_FILTER_OFF(QS_QEP_STATE_EXIT);
//    QS_FILTER_OFF(QS_QEP_STATE_INIT);
//    QS_FILTER_OFF(QS_QEP_INIT_TRAN);
//    QS_FILTER_OFF(QS_QEP_INTERN_TRAN);
//    QS_FILTER_OFF(QS_QEP_TRAN);
//    QS_FILTER_OFF(QS_QEP_IGNORED);

//    QS_FILTER_OFF(QS_QF_ACTIVE_ADD);
//    QS_FILTER_OFF(QS_QF_ACTIVE_REMOVE);
//    QS_FILTER_OFF(QS_QF_ACTIVE_SUBSCRIBE);
//    QS_FILTER_OFF(QS_QF_ACTIVE_UNSUBSCRIBE);
//    QS_FILTER_OFF(QS_QF_ACTIVE_POST_FIFO);
//    QS_FILTER_OFF(QS_QF_ACTIVE_POST_LIFO);
//    QS_FILTER_OFF(QS_QF_ACTIVE_GET);
//    QS_FILTER_OFF(QS_QF_ACTIVE_GET_LAST);
//    QS_FILTER_OFF(QS_QF_EQUEUE_INIT);
//    QS_FILTER_OFF(QS_QF_EQUEUE_POST_FIFO);
//    QS_FILTER_OFF(QS_QF_EQUEUE_POST_LIFO);
//    QS_FILTER_OFF(QS_QF_EQUEUE_GET);
//    QS_FILTER_OFF(QS_QF_EQUEUE_GET_LAST);
//    QS_FILTER_OFF(QS_QF_MPOOL_INIT);
//    QS_FILTER_OFF(QS_QF_MPOOL_GET);
//    QS_FILTER_OFF(QS_QF_MPOOL_PUT);
//    QS_FILTER_OFF(QS_QF_PUBLISH);
//    QS_FILTER_OFF(QS_QF_NEW);
//    QS_FILTER_OFF(QS_QF_GC_ATTEMPT);
//    QS_FILTER_OFF(QS_QF_GC);
    QS_FILTER_OFF(QS_QF_TICK);
//    QS_FILTER_OFF(QS_QF_TIMEEVT_ARM);
//    QS_FILTER_OFF(QS_QF_TIMEEVT_AUTO_DISARM);
//    QS_FILTER_OFF(QS_QF_TIMEEVT_DISARM_ATTEMPT);
//    QS_FILTER_OFF(QS_QF_TIMEEVT_DISARM);
//    QS_FILTER_OFF(QS_QF_TIMEEVT_REARM);
//    QS_FILTER_OFF(QS_QF_TIMEEVT_POST);
    QS_FILTER_OFF(QS_QF_INT_LOCK);
    QS_FILTER_OFF(QS_QF_INT_UNLOCK);
    QS_FILTER_OFF(QS_QF_ISR_ENTRY);
    QS_FILTER_OFF(QS_QF_ISR_EXIT);

//    QS_FILTER_OFF(QS_QK_MUTEX_LOCK);
//    QS_FILTER_OFF(QS_QK_MUTEX_UNLOCK);
//    QS_FILTER_OFF(QS_QK_SCHEDULE);

    return (uint8_t)1;                                       // return success
}
//............................................................................
void QS::onCleanup(void) {
}
//............................................................................
QSTimeCtr QS::onGetTime(void) {              // invoked with interrupts locked
    if ((SysTick->CTRL & 0x00000100) == 0) {              // COUNTFLAG no set?
        return l_tickTime - (QSTimeCtr)SysTick->VAL;
    }
    else {        // the rollover occured, but the SysTick_ISR did not run yet
        return l_tickTime + l_tickPeriod - (QSTimeCtr)SysTick->VAL;
    }
}
//............................................................................
void QS::onFlush(void) {
    uint16_t b;
    QF_INT_LOCK(dummy);
    while ((b = QS::getByte()) != QS_EOD) {
        while (!l_qspy.writeable()) {    // wait until serial port is writable
        }
        l_qspy.putc((uint8_t)b);
    }
    QF_INT_UNLOCK(dummy);
}
#endif                                                                // Q_SPY
//----------------------------------------------------------------------------
