//////////////////////////////////////////////////////////////////////////////
// Model: Network.qm
// File:  ./network.cpp
//
// This file has been generated automatically by QP Modeler (QM).
// DO NOT EDIT THIS FILE MANUALLY.
//
// Please visit www.state-machine.com/qm for more information.
//////////////////////////////////////////////////////////////////////////////
#include "qp_port.h"
#include "bsp.h"
#include "network.h"

Q_DEFINE_THIS_FILE

enum PelicanTimeouts {                            // various timeouts in ticks
    CARS_GREEN_MIN_TOUT = BSP_TICKS_PER_SEC * 8,         // min green for cars
    CARS_YELLOW_TOUT = BSP_TICKS_PER_SEC * 3,               // yellow for cars
    PEDS_WALK_TOUT   = BSP_TICKS_PER_SEC * 3,         // walking time for peds
    PEDS_FLASH_TOUT  = BSP_TICKS_PER_SEC / 5,     // flashing timeout for peds
    PEDS_FLASH_NUM   = 5*2,                      // number of flashes for peds
    OFF_FLASH_TOUT   = BSP_TICKS_PER_SEC / 2      // flashing timeout when off
};

enum SenseTimeouts {                            // various timeouts in ticks
    SENSE1_N1_TOUT = BSP_TICKS_PER_SEC * 3,
    TOGGLE_TOUT = BSP_TICKS_PER_SEC/5
};

enum PollTimeouts {                                // various timeouts in ticks
    POLL_TOUT = BSP_TICKS_PER_SEC /10,     // poll wait
};

// Pelican class -------------------------------------------------------------
// $(components::Pelican) ....................................................
class Pelican : public QActive {
private:
    QTimeEvt m_timeout;
    uint8_t m_flashCtr;

public:
    Pelican() : QActive((QStateHandler)&Pelican::initial), m_timeout(TIMEOUT_SIG) {
    }

protected:
    static QState initial(Pelican *me, QEvent const *e);
    static QState operational(Pelican *me, QEvent const *e);
    static QState carsEnabled(Pelican *me, QEvent const *e);
    static QState carsGreen(Pelican *me, QEvent const *e);
    static QState carsGreenNoPed(Pelican *me, QEvent const *e);
    static QState carsGreenInt(Pelican *me, QEvent const *e);
    static QState carsGreenPedWait(Pelican *me, QEvent const *e);
    static QState carsYellow(Pelican *me, QEvent const *e);
    static QState pedsEnabled(Pelican *me, QEvent const *e);
    static QState pedsWalk(Pelican *me, QEvent const *e);
    static QState pedsFlash(Pelican *me, QEvent const *e);
    static QState offline(Pelican *me, QEvent const *e);
};
// $(components::Sense1_N1) ..................................................
class Sense1_N1 : public QActive {
private:
    QTimeEvt m_timeout;

public:
    Sense1_N1();

protected:
    static QState initial(Sense1_N1 *me, QEvent const *e);
    static QState disconnected(Sense1_N1 *me, QEvent const *e);
    static QState connected(Sense1_N1 *me, QEvent const *e);
    static QState toggle_sense(Sense1_N1 *me, QEvent const *e);
    static QState detect_down(Sense1_N1 *me, QEvent const *e);
};
// $(components::Poll) .......................................................
class Poll : public QActive {
private:
    QTimeEvt m_timeout;

public:
    Poll();

protected:
    static QState initial(Poll *me, QEvent const *e);
    static QState poll(Poll *me, QEvent const *e);
};

// Local objects -------------------------------------------------------------
static Pelican l_Pelican;      // the single instance of Pelican active object
static Sense1_N1 l_Sense1_N1;      // the single instance of Pelican active
static Poll l_Poll;      // the single instance of Poll


// Global objects ------------------------------------------------------------
QActive * const AO_Pelican = &l_Pelican;                 // the opaque pointer
QActive * const AO_Sense1_N1 = &l_Sense1_N1;             // the opaque pointer
QActive * const AO_Poll = &l_Poll;             // the opaque pointer

// Pelican class definition --------------------------------------------------
// $(components::Pelican) ....................................................

// $(components::Pelican::Statechart) ........................................
// @(/1/0/3/0)
QState Pelican::initial(Pelican *me, QEvent const *e) {
    me->subscribe(PEDS_WAITING_SIG);

    QS_OBJ_DICTIONARY(&l_Pelican);
    QS_OBJ_DICTIONARY(&l_Pelican.m_timeout);

    QS_FUN_DICTIONARY(&QHsm::top);
    QS_FUN_DICTIONARY(&Pelican::initial);
    QS_FUN_DICTIONARY(&Pelican::offline);
    QS_FUN_DICTIONARY(&Pelican::operational);
    QS_FUN_DICTIONARY(&Pelican::carsEnabled);
    QS_FUN_DICTIONARY(&Pelican::carsGreen);
    QS_FUN_DICTIONARY(&Pelican::carsGreenNoPed);
    QS_FUN_DICTIONARY(&Pelican::carsGreenPedWait);
    QS_FUN_DICTIONARY(&Pelican::carsGreenInt);
    QS_FUN_DICTIONARY(&Pelican::carsYellow);
    QS_FUN_DICTIONARY(&Pelican::pedsEnabled);
    QS_FUN_DICTIONARY(&Pelican::pedsWalk);
    QS_FUN_DICTIONARY(&Pelican::pedsFlash);

    QS_SIG_DICTIONARY(PEDS_WAITING_SIG, 0);  // global signals
    QS_SIG_DICTIONARY(ON_SIG,           0);
    QS_SIG_DICTIONARY(OFF_SIG,          0);

    QS_SIG_DICTIONARY(TIMEOUT_SIG,      &l_Pelican); // just for Pelican
    return Q_TRAN(&Pelican::operational);
}
// $(components::Pelican::Statechart::operational) ...........................
QState Pelican::operational(Pelican *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/0/3/1)
        case Q_ENTRY_SIG: {
            BSP_signalCars(CARS_RED);
            BSP_signalPeds(PEDS_DONT_WALK);
            return Q_HANDLED();
        }
        // @(/1/0/3/1/0)
        case Q_INIT_SIG: {
            return Q_TRAN(&Pelican::carsEnabled);
        }
        // @(/1/0/3/1/1)
        case OFF_SIG: {
            return Q_TRAN(&Pelican::offline);
        }
    }
    return Q_SUPER(&QHsm::top);
}
// $(components::Pelican::Statechart::operational::carsEnabled) ..............
QState Pelican::carsEnabled(Pelican *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/0/3/1/2)
        case Q_EXIT_SIG: {
            BSP_signalCars(CARS_RED);
            return Q_HANDLED();
        }
        // @(/1/0/3/1/2/0)
        case Q_INIT_SIG: {
            return Q_TRAN(&Pelican::carsGreen);
        }
    }
    return Q_SUPER(&Pelican::operational);
}
// $(components::Pelican::Statechart::operational::carsEnabled::carsGreen) ...
QState Pelican::carsGreen(Pelican *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/0/3/1/2/1)
        case Q_ENTRY_SIG: {
            BSP_signalCars(CARS_GREEN);
            me->m_timeout.postIn(me, CARS_GREEN_MIN_TOUT);
            return Q_HANDLED();
        }
        // @(/1/0/3/1/2/1)
        case Q_EXIT_SIG: {
            me->m_timeout.disarm();
            return Q_HANDLED();
        }
        // @(/1/0/3/1/2/1/0)
        case Q_INIT_SIG: {
            return Q_TRAN(&Pelican::carsGreenNoPed);
        }
    }
    return Q_SUPER(&Pelican::carsEnabled);
}
// $(components::Pelican::Statechart::operational::carsEnabled::carsGreen::carsGreenNoPed) 
QState Pelican::carsGreenNoPed(Pelican *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/0/3/1/2/1/1)
        case Q_ENTRY_SIG: {
            BSP_showState("carsGreenNoPed");
            return Q_HANDLED();
        }
        // @(/1/0/3/1/2/1/1/0)
        case PEDS_WAITING_SIG: {
            return Q_TRAN(&Pelican::carsGreenPedWait);
        }
        // @(/1/0/3/1/2/1/1/1)
        case TIMEOUT_SIG: {
            return Q_TRAN(&Pelican::carsGreenInt);
        }
    }
    return Q_SUPER(&Pelican::carsGreen);
}
// $(components::Pelican::Statechart::operational::carsEnabled::carsGreen::carsGreenInt) 
QState Pelican::carsGreenInt(Pelican *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/0/3/1/2/1/2)
        case Q_ENTRY_SIG: {
            BSP_showState("carsGreenInt");
            return Q_HANDLED();
        }
        // @(/1/0/3/1/2/1/2/0)
        case PEDS_WAITING_SIG: {
            return Q_TRAN(&Pelican::carsYellow);
        }
    }
    return Q_SUPER(&Pelican::carsGreen);
}
// $(components::Pelican::Statechart::operational::carsEnabled::carsGreen::carsGreenPedWait) 
QState Pelican::carsGreenPedWait(Pelican *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/0/3/1/2/1/3)
        case Q_ENTRY_SIG: {
            BSP_showState("carsGreenPedWait");
            return Q_HANDLED();
        }
        // @(/1/0/3/1/2/1/3/0)
        case TIMEOUT_SIG: {
            return Q_TRAN(&Pelican::carsYellow);
        }
    }
    return Q_SUPER(&Pelican::carsGreen);
}
// $(components::Pelican::Statechart::operational::carsEnabled::carsYellow) ..
QState Pelican::carsYellow(Pelican *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/0/3/1/2/2)
        case Q_ENTRY_SIG: {
            BSP_showState("carsYellow");
            BSP_signalCars(CARS_YELLOW);
            me->m_timeout.postIn(me, CARS_YELLOW_TOUT);
            return Q_HANDLED();
        }
        // @(/1/0/3/1/2/2)
        case Q_EXIT_SIG: {
            me->m_timeout.disarm();
            return Q_HANDLED();
        }
        // @(/1/0/3/1/2/2/0)
        case TIMEOUT_SIG: {
            return Q_TRAN(&Pelican::pedsEnabled);
        }
    }
    return Q_SUPER(&Pelican::carsEnabled);
}
// $(components::Pelican::Statechart::operational::pedsEnabled) ..............
QState Pelican::pedsEnabled(Pelican *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/0/3/1/3)
        case Q_EXIT_SIG: {
            BSP_signalPeds(PEDS_DONT_WALK);
            return Q_HANDLED();
        }
        // @(/1/0/3/1/3/0)
        case Q_INIT_SIG: {
            return Q_TRAN(&Pelican::pedsWalk);
        }
    }
    return Q_SUPER(&Pelican::operational);
}
// $(components::Pelican::Statechart::operational::pedsEnabled::pedsWalk) ....
QState Pelican::pedsWalk(Pelican *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/0/3/1/3/1)
        case Q_ENTRY_SIG: {
            BSP_showState("pedsWalk");
            BSP_signalPeds(PEDS_WALK);
            me->m_timeout.postIn(me, PEDS_WALK_TOUT);
            return Q_HANDLED();
        }
        // @(/1/0/3/1/3/1)
        case Q_EXIT_SIG: {
            me->m_timeout.disarm();
            return Q_HANDLED();
        }
        // @(/1/0/3/1/3/1/0)
        case TIMEOUT_SIG: {
            return Q_TRAN(&Pelican::pedsFlash);
        }
    }
    return Q_SUPER(&Pelican::pedsEnabled);
}
// $(components::Pelican::Statechart::operational::pedsEnabled::pedsFlash) ...
QState Pelican::pedsFlash(Pelican *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/0/3/1/3/2)
        case Q_ENTRY_SIG: {
            BSP_showState("pedsFlash");
            me->m_timeout.postEvery(me, PEDS_FLASH_TOUT);
            me->m_flashCtr = PEDS_FLASH_NUM*2 + 1;
            return Q_HANDLED();
        }
        // @(/1/0/3/1/3/2)
        case Q_EXIT_SIG: {
            me->m_timeout.disarm();
            return Q_HANDLED();
        }
        // @(/1/0/3/1/3/2/0)
        case TIMEOUT_SIG: {
            // @(/1/0/3/1/3/2/0/0)
            if (me->m_flashCtr != 0) {
                --me->m_flashCtr;
                // @(/1/0/3/1/3/2/0/0/0)
                if ((me->m_flashCtr & 1) == 0) {
                    BSP_signalPeds(PEDS_DONT_WALK);
                    return Q_HANDLED();
                }
                // @(/1/0/3/1/3/2/0/0/1)
                else {
                    BSP_signalPeds(PEDS_BLANK);
                    return Q_HANDLED();
                }
            }
            // @(/1/0/3/1/3/2/0/1)
            else {
                return Q_TRAN(&Pelican::carsEnabled);
            }
        }
    }
    return Q_SUPER(&Pelican::pedsEnabled);
}
// $(components::Pelican::Statechart::offline) ...............................
QState Pelican::offline(Pelican *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/0/3/2)
        case Q_ENTRY_SIG: {
            BSP_showState("offline");
            me->m_timeout.postEvery(me, OFF_FLASH_TOUT);
            me->m_flashCtr = 0;
            return Q_HANDLED();
        }
        // @(/1/0/3/2)
        case Q_EXIT_SIG: {
            me->m_timeout.disarm();
            return Q_HANDLED();
        }
        // @(/1/0/3/2/0)
        case TIMEOUT_SIG: {
            me->m_flashCtr ^= 1;
            // @(/1/0/3/2/0/0)
            if ((me->m_flashCtr & 1) == 0) {
                BSP_signalCars(CARS_RED);
                BSP_signalPeds(PEDS_DONT_WALK);
                return Q_HANDLED();
            }
            // @(/1/0/3/2/0/1)
            else {
                BSP_signalCars(CARS_BLANK);
                BSP_signalPeds(PEDS_BLANK);
                return Q_HANDLED();
            }
        }
        // @(/1/0/3/2/1)
        case ON_SIG: {
            return Q_TRAN(&Pelican::operational);
        }
    }
    return Q_SUPER(&QHsm::top);
}

// $(components::Sense1_N1) ..................................................
// $(components::Sense1_N1::Sense1_N1) .......................................
Sense1_N1::Sense1_N1() : QActive((QStateHandler)&Sense1_N1::initial), m_timeout(TIMEOUT_SIG) {
}
// $(components::Sense1_N1::Statechart) ......................................
// @(/1/2/2/0)
QState Sense1_N1::initial(Sense1_N1 *me, QEvent const *e) {
    me->subscribe(SENSE1_N1_UP_SIG);
    me->subscribe(SENSE1_N1_DOWN_SIG);
    me->subscribe(SENSE_N1_SIG);

    QS_OBJ_DICTIONARY(&l_Sense1_N1);
    QS_OBJ_DICTIONARY(&l_Sense1_N1.m_timeout);

    QS_FUN_DICTIONARY(&QHsm::top);
    QS_FUN_DICTIONARY(&Sense1_N1::initial);
    QS_FUN_DICTIONARY(&Sense1_N1::disconnected);
    QS_FUN_DICTIONARY(&Sense1_N1::connected);
    QS_FUN_DICTIONARY(&Sense1_N1::toggle_sense);
    QS_FUN_DICTIONARY(&Sense1_N1::detect_down);

    QS_SIG_DICTIONARY(SENSE1_N1_UP_SIG, 0);  // global signals
    QS_SIG_DICTIONARY(SENSE1_N1_DOWN_SIG,0);
    QS_SIG_DICTIONARY(SENSE_N1_SIG,0);

    QS_SIG_DICTIONARY(TIMEOUT_SIG,      &l_Sense1_N1); // just for Sense1_N1
    return Q_TRAN(&Sense1_N1::disconnected);
}
// $(components::Sense1_N1::Statechart::disconnected) ........................
QState Sense1_N1::disconnected(Sense1_N1 *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/2/2/1)
        case Q_ENTRY_SIG: {
            BSP_signalSense(SENSE_1_DIS);
            return Q_HANDLED();
        }
        // @(/1/2/2/1/0)
        case SENSE1_N1_UP_SIG: {
            return Q_TRAN(&Sense1_N1::connected);
        }
    }
    return Q_SUPER(&QHsm::top);
}
// $(components::Sense1_N1::Statechart::connected) ...........................
QState Sense1_N1::connected(Sense1_N1 *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/2/2/2)
        case Q_ENTRY_SIG: {
            BSP_signalSense(SENSE_1_CON);
            return Q_HANDLED();
        }
        // @(/1/2/2/2/0)
        case SENSE1_N1_DOWN_SIG: {
            return Q_TRAN(&Sense1_N1::disconnected);
        }
        // @(/1/2/2/2/1)
        case SENSE_N1_SIG: {
            return Q_TRAN(&Sense1_N1::toggle_sense);
        }
    }
    return Q_SUPER(&QHsm::top);
}
// $(components::Sense1_N1::Statechart::toggle_sense) ........................
QState Sense1_N1::toggle_sense(Sense1_N1 *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/2/2/3)
        case Q_ENTRY_SIG: {
            me->m_timeout.postIn(me, TOGGLE_TOUT);
            return Q_HANDLED();
        }
        // @(/1/2/2/3)
        case Q_EXIT_SIG: {
            me->m_timeout.disarm();
            return Q_HANDLED();
        }
        // @(/1/2/2/3/0)
        case TIMEOUT_SIG: {
            return Q_TRAN(&Sense1_N1::connected);
        }
        // @(/1/2/2/3/1)
        case SENSE1_N1_DOWN_SIG: {
            return Q_TRAN(&Sense1_N1::detect_down);
        }
    }
    return Q_SUPER(&QHsm::top);
}
// $(components::Sense1_N1::Statechart::detect_down) .........................
QState Sense1_N1::detect_down(Sense1_N1 *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/2/2/4)
        case Q_ENTRY_SIG: {
            me->m_timeout.postIn(me, TOGGLE_TOUT);
            return Q_HANDLED();
        }
        // @(/1/2/2/4)
        case Q_EXIT_SIG: {
            me->m_timeout.disarm();
            return Q_HANDLED();
        }
        // @(/1/2/2/4/0)
        case TIMEOUT_SIG: {
            return Q_TRAN(&Sense1_N1::disconnected);
        }
        // @(/1/2/2/4/1)
        case SENSE1_N1_UP_SIG: {
            return Q_TRAN(&Sense1_N1::connected);
        }
    }
    return Q_SUPER(&QHsm::top);
}

// $(components::Poll) .......................................................
// $(components::Poll::Poll) .................................................
Poll::Poll() : QActive((QStateHandler)&Poll::initial), m_timeout(TIMEOUT_SIG) {
}
// $(components::Poll::Statechart) ...........................................
// @(/1/1/2/0)
QState Poll::initial(Poll *me, QEvent const *e) {
    QS_OBJ_DICTIONARY(&l_Poll);
    QS_OBJ_DICTIONARY(&l_Poll.m_timeout);


    QS_FUN_DICTIONARY(&QHsm::top);
    QS_FUN_DICTIONARY(&Poll::initial);
    QS_FUN_DICTIONARY(&Poll::poll);


    QS_SIG_DICTIONARY(TIMEOUT_SIG, &l_Poll);  // just for Ped

    me->m_timeout.postEvery(me, POLL_TOUT);

    return Q_TRAN(&Poll::poll);
}
// $(components::Poll::Statechart::poll) .....................................
QState Poll::poll(Poll *me, QEvent const *e) {
    switch (e->sig) {
        // @(/1/1/2/1)
        case Q_EXIT_SIG: {
            BSP_chk_io();
            return Q_HANDLED();
        }
        // @(/1/1/2/1/0)
        case TIMEOUT_SIG: {
            return Q_TRAN(&Poll::poll);
        }
    }
    return Q_SUPER(&QHsm::top);
}

