
#include "mbed.h"


DigitalIn fire(p14); // fire is an Object of class DigitalIn(centre pin of joystick)
PwmOut speaker(p26); // spkr is an Object of class PwmOut (speaker output)
AnalogIn pot1(p19);
float start = 2000.0;//start is a variable of type float and equal to 2000.
float end = 4000.0;//end is a variable of type float and equal to 1000.
float step = 100;//step is a variable of type float and equal to 100.
float loop =0;

int main()
{
    while(loop < 2) {// only repeat loop twice
        for (float i= 2000.0; i<4000.0; i+=100) {//i is equal to i+100
            speaker.period(1.0/i);//set the PWM period to 1/frequency of the desired sound.
            speaker=0.5;//50% duty cycle - max volume
            wait(0.2);
        }
        for (float i = start; i<end; i+=step) {
            speaker.period(1.0/i);
            speaker=0.25;//25% duty cycle - mid range volume
            wait(0.3);
            speaker=0.0;//  off audio
        }
        while(!fire) {}//this uses the joystick to control the program

    }
}
