
#include "mbed.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);// an object of class C 12832 LCD called LCD
InterruptIn joystickcenter(p14);//joystickcenter is an Object of class InterruptIn
InterruptIn button(p9);//button is an Object of class  InterruptIn
DigitalOut led(LED1);// led is an Object of class Digital Out
DigitalOut flash(LED4);// flash is an Object of class Digital Out
int x; // variable for flip function

void flip() // function does not return a value
{
    led = !led; // toggles the led when the joystick button is pressed  (not equal to). }
    x = 1;  // toggles the led, when pressing a button connects to p9.
}
int main()
{
    lcd.cls();
    lcd.locate(0,0);// Clear the screen and locate to 0,0. 
    joystickcenter.rise(&flip); // attach the function address to the rising edge
    button.mode(PullUp);        // With this, no external pullup resistor needed
    button.rise(&flip);         // attach the function address to the rising edge
    while(1) {                  // wait around, interrupts will interrupt this!
        flash = !flash;         // turns LED4 on if off, off if on
        if( x == 1) {
            lcd.printf("variable is set %d \n", led.read());
            x = 0;
            wait(0.25);             // the instruction to wait for a quarter-second
        }
    }
}
