#include "mbed.h"
#include "C12832.h" // including lcd library
 
InterruptIn joystickcenter(p14);
InterruptIn button(p9);
DigitalOut led(LED1);
DigitalOut flash(LED4);
C12832 lcd(p5, p7, p6, p8, p11);
int buttonstate;
int var;    // declare a variable
long debounce = 200;
void flip() // Classes a flip function

{
    var = 1; // Variable is high
    led = !led; // toggles the led when the joystick button is pressed.
}
int main()
{
    if (button.Current == 1 && button.Previous == 0 && ms() - t > debounce);
    ms = time;
    joystickcenter.rise(&flip); //attach the function address to the rising edge
    button.mode(PullUp); // With this, no external pullup resistor needed
    button.rise(&flip); // attach the function address to the rising edge
    while(1) { // wait around, interrupts will interrupt this!
        flash = !flash; // turns LED4 on if off, off if on
        wait(0.25); // the instruction to wait for a quarter-second
        
        
        if (var == 1 && ms()-time > debounce)   // Check if variable has been set 
        {
            debounce.read_ms(200);
            debounce.reset();
            lcd.locate(0,0); // print to LCD
            lcd.printf("The variable has been set");
            wait(3);
            lcd.cls();              // Clears LCD
            var=0;                  // Variable returns to low state
            
            time = milis();
        }
    }
}