 // My first program did not have an interrupt and as a result sometime it would
 // display the button twice. this was resolved by the use on an interrupt.
 //     A hardware option to control debouncing would be the use of a capacitor
 // this will allow for a smooth switch. For a software solution an interrupt is
 // used for debouncing.
 
 #include "mbed.h"
Serial pc (USBTX, USBRX);

InterruptIn center(p14);
InterruptIn left(p13);
InterruptIn right(p16);
InterruptIn up(p15);
InterruptIn down(p12);

void center_released() { wait (0.25);
}
void center_pressed() {
    pc.printf("center\n\r");
}
void left_released() { wait (0.25);
}   
void left_pressed() {
    pc.printf("left\n\r");
}
void right_released() { wait (0.25);
}
void right_pressed() {
    pc.printf("right\n\r");
}
void up_released() { wait (0.25);
}
void up_pressed() {
    pc.printf("up\n\r");
}
void down_released() { wait (0.25);
}
void down_pressed() {
    pc.printf("down\n\r");
}
int main() {
 
    // Both rise and fall edges generate an interrupt
    center.fall(&center_released);
    center.rise(&center_pressed);
    left.fall(&left_released);
    left.rise(&left_pressed);
    right.fall(&right_released);
    right.rise(&right_pressed);
    up.fall(&up_released);
    up.rise(&up_pressed);
    down.fall(&down_released);
    down.rise(&down_pressed);
   
    left.mode(PullDown);
    right.mode(PullDown);
    up.mode(PullDown);
    down.mode(PullDown);
   
    while (1) {     
    }
}